/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.service;

import com.roma.romaapi.dao.ApiDao;
import com.roma.romaapi.dao.PageDao;
import com.roma.romaapi.utils.CommonUtil;
import com.roma.romaapi.utils.JWTUtil;
import com.roma.romaapi.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ApiService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ApiDao apiDao;
    @Autowired
    PageDao pageDao;
    @Autowired
    SecurityUtils securityUtils;
    @Autowired
    JWTUtil jwtUtil;
    @Autowired
    CommonUtil commonUtil;

    public Map<String, Object> login(Map<String, String[]> maps) {
        String userName = maps.get("api_name")[0];
        String password = maps.get("api_password")[0];
        String captcha = maps.get("api_captcha")[0];
        String captchaToken = maps.get("captchaToken")[0];
        String captchaTokenValue = this.redisTemplate.opsForValue().get(captchaToken);
        HashMap<String, Object> loginResult = new HashMap<String, Object>();
        Map<String, Object> UserInfo = this.apiDao.adminInfoQueryForMap(userName);
        if (UserInfo.containsKey("sysErrorCode")) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
            return loginResult;
        }
        Object adminPassword = UserInfo.get("admin_password");
        String stringAdminPassword = adminPassword.toString();
        if (!this.securityUtils.matchesPassword(password, stringAdminPassword)) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
            return loginResult;
        }
        if (!Boolean.TRUE.equals(this.redisTemplate.hasKey(captchaToken)) || !Objects.equals(captchaTokenValue, captcha)) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginResult;
        }
        HashMap<String, Object> jwtInfo = new HashMap<String, Object>();
        Object userId = UserInfo.get("id");
        String stringUserId = userId.toString();
        jwtInfo.put("id", stringUserId);
        jwtInfo.put("loginTime", "" + System.currentTimeMillis() / 1000L);
        jwtInfo.put("name", userName);
        String jwtToken = this.jwtUtil.getToken(jwtInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loginToken", jwtToken);
        return map;
    }

    public Map<String, Object> userInfo(String headerToken) {
        Map<String, Object> userInfo;
        String userId = this.commonUtil.getUserIdByHeaderAuthorization(headerToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (userId.length() > 0 && (userInfo = this.apiDao.userInfoByIdQueryForMap(userId)).containsKey("admin_name")) {
            map.put("userName", userInfo.get("admin_name"));
        }
        return map;
    }

    public Map<String, Object> getUserInfoById(Map params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String userId = params.get("id").toString();
        if (userId.length() > 0) {
            Map<String, Object> userInfo = this.apiDao.enableAndNoEnableUserInfoByIdQueryForMap(userId);
            map.put("admin_name", userInfo.get("admin_name"));
            map.put("api_upload_pic", userInfo.get("admin_avatar"));
            map.put("is_enable", userInfo.get("is_enable"));
            map.put("admin_email", userInfo.get("admin_email"));
            map.put("admin_phone", userInfo.get("admin_phone"));
            List<Map<String, Object>> userAllRole = this.apiDao.getAllRoleByUserId(userId);
            Object userAllRoleString = "";
            if (userAllRole.size() > 0) {
                for (int i2 = 0; i2 < userAllRole.size(); ++i2) {
                    Map<String, Object> nowRole = userAllRole.get(i2);
                    String permissionId = nowRole.get("role_id").toString();
                    userAllRoleString = (String)userAllRoleString + permissionId + ",";
                }
                userAllRoleString = this.commonUtil.trimFirstAndLastChar((String)userAllRoleString, ",");
            }
            map.put("user_role", userAllRoleString);
        }
        return map;
    }

    public Map<String, Object> logout(String headerToken) {
        Boolean logout = this.commonUtil.logoutDeleteRedisToken(headerToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysErrorCode", "50000");
        return map;
    }

    public List permissionList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllMenuForList();
        List<Map<String, Object>> treeMenu = this.treeMenu(menuData);
        return treeMenu;
    }

    public List selectPermissionList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getPageMenuForList();
        List<Map<String, Object>> treeMenu = this.treeMenu(menuData);
        return treeMenu;
    }

    public Map roleList(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.apiDao.getAllRoleListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.apiDao.getAllRoleListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public Map roleDetailById(Map params) {
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("roma_roles", id);
        List<Map<String, Object>> roleAllPermission = this.apiDao.getAllPermissionByRoleId(id);
        Object permissionAllString = "";
        if (roleAllPermission.size() > 0) {
            for (int i2 = 0; i2 < roleAllPermission.size(); ++i2) {
                Map<String, Object> map = roleAllPermission.get(i2);
                String permissionId = map.get("permission_id").toString();
                permissionAllString = (String)permissionAllString + permissionId + ",";
            }
            permissionAllString = this.commonUtil.trimFirstAndLastChar((String)permissionAllString, ",");
        }
        info2.put("permission_info", permissionAllString);
        return info2;
    }

    public Map sqlDetailById(Map params) {
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("sql_details", id);
        if (info2.get("sql_type").toString().equals("update") && info2.get("is_list").toString().equals("0")) {
            info2.put("is_list", "1");
        }
        return info2;
    }

    public Map delDetailById(Map params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String id = params.get("id").toString();
        String action = params.get("action").toString();
        String table = "";
        if (action.equals("sql")) {
            table = "sql_details";
        } else if (action.equals("item")) {
            table = "item_details";
        } else if (action.equals("api")) {
            table = "api_details";
        } else if (action.equals("page")) {
            table = "page_details";
        }
        HashMap<String, String> hasUsedByPermission = new HashMap<String, String>();
        hasUsedByPermission.put("objectType", action);
        hasUsedByPermission.put("objectId", id);
        Boolean isUsedPermission = this.apiDao.usedPermissionByObjectId(hasUsedByPermission);
        if (!isUsedPermission.booleanValue()) {
            ret.put("sysErrorCode", "51000");
            ret.put("sysErrorMessage", "\u6b64\u6570\u636e\u88ab\u6743\u9650\u4f7f\u7528\u4e2d,\u65e0\u6cd5\u5220\u9664");
            return ret;
        }
        HashMap<String, String> deleteParams = new HashMap<String, String>();
        deleteParams.put("id", id);
        Integer delRet = this.apiDao.deleteDetailsDataByTableNameAndId(deleteParams, table);
        if (delRet < 1) {
            ret.put("sysErrorCode", "51000");
        }
        return ret;
    }

    public Map deletePermissionById(Map params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String id = params.get("id").toString();
        HashMap<String, String> hasParams = new HashMap<String, String>();
        hasParams.put("id", id);
        Boolean hasRet = this.apiDao.hasSonPermissionById(hasParams);
        if (!hasRet.booleanValue()) {
            ret.put("sysErrorCode", "51000");
            ret.put("sysErrorMessage", "\u6b64\u6743\u9650\u4e0b\u6709\u5b50\u6743\u9650,\u8bf7\u5148\u5220\u9664\u5b50\u6743\u9650");
            return ret;
        }
        Integer deleteData = this.apiDao.deletePermissionById(hasParams);
        if (deleteData < 1) {
            ret.put("sysErrorCode", "51000");
        }
        return ret;
    }

    public List pageList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllPageList();
        for (Map<String, Object> tmp : menuData) {
            tmp.put("show_name", String.valueOf(tmp.get("page_code")) + " / " + String.valueOf(tmp.get("page_name")));
        }
        return menuData;
    }

    public Map pageListHasPaging(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.pageDao.getAllPageListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.pageDao.getAllPageListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public Map sqlListHasPaging(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.pageDao.getAllSqlListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.pageDao.getAllSqlListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public Map apiListHasPaging(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.pageDao.getAllApiListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.pageDao.getAllApiListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public Map itemListHasPaging(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.pageDao.getAllItemListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.pageDao.getAllItemListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public List sqlList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllSqlList();
        for (Map<String, Object> tmp : menuData) {
            tmp.put("show_name", String.valueOf(tmp.get("sql_code")) + " / " + String.valueOf(tmp.get("sql_name")));
        }
        return menuData;
    }

    public List apiList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllApiList();
        for (Map<String, Object> tmp : menuData) {
            tmp.put("show_name", String.valueOf(tmp.get("api_code")) + " / " + String.valueOf(tmp.get("api_name")));
        }
        return menuData;
    }

    public List roleList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllRoleList();
        return menuData;
    }

    public List itemList() {
        HashMap map = new HashMap();
        List<Map<String, Object>> menuData = this.pageDao.getAllItemList();
        for (Map<String, Object> tmp : menuData) {
            tmp.put("show_name", String.valueOf(tmp.get("item_code")) + " / " + String.valueOf(tmp.get("item_name")));
        }
        return menuData;
    }

    public Map addPermissions(Map maps) {
        Map<String, String> ret = new HashMap<String, String>();
        if (!maps.containsKey("object_type")) {
            ret.put("sysErrorCode", "51000");
            return ret;
        }
        ret = this.handlePagePermission(maps);
        return ret;
    }

    private Map handlePagePermission(Map params) {
        String isEnable = "1";
        String objectType = params.get("object_type").toString();
        String isVisible = "0";
        String isMenu = "0";
        String menuName = "";
        String objectId = "0";
        String parentId = "0";
        String permissionDescribe = "";
        String permissionSort = "0";
        String permissionsIcon = "";
        String isDir = "0";
        String id = "";
        if (params.containsKey("is_dir")) {
            isDir = params.get("is_dir").toString();
            if (isDir.equals("1") || isDir.equals("2")) {
                isMenu = isDir;
            }
            permissionsIcon = isDir.equals("1") ? "ri-folder-2-line" : params.get("permissions_icon").toString();
        }
        if (params.containsKey("id")) {
            id = params.get("id").toString();
        }
        if (params.containsKey("is_visible")) {
            isVisible = params.get("is_visible").toString();
        }
        if (params.containsKey("is_menu")) {
            isMenu = params.get("is_menu").toString();
        }
        if (params.containsKey("menu_name")) {
            menuName = params.get("menu_name").toString();
        }
        if (objectType.equals("page")) {
            if (params.containsKey("page_id")) {
                objectId = params.get("page_id").toString();
            }
        } else if (objectType.equals("sql")) {
            if (params.containsKey("sql_id")) {
                objectId = params.get("sql_id").toString();
            }
        } else if (objectType.equals("api")) {
            if (params.containsKey("api_id")) {
                objectId = params.get("api_id").toString();
            }
        } else if (objectType.equals("item") && params.containsKey("item_id")) {
            objectId = params.get("item_id").toString();
        }
        if (params.containsKey("parent_id")) {
            parentId = params.get("parent_id").toString();
        }
        if (params.containsKey("permission_describe")) {
            permissionDescribe = params.get("permission_describe").toString();
        }
        if (params.containsKey("permission_sort")) {
            permissionSort = params.get("permission_sort").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, String> bindVal = new HashMap<String, String>();
        bindVal.put("isEnable", isEnable);
        bindVal.put("isMenu", isMenu);
        bindVal.put("isVisible", isVisible);
        bindVal.put("objectType", objectType);
        bindVal.put("menuName", menuName);
        bindVal.put("objectId", objectId);
        bindVal.put("parentId", parentId);
        bindVal.put("permissionDescribe", permissionDescribe);
        bindVal.put("permissionSort", permissionSort);
        bindVal.put("permissionsIcon", permissionsIcon);
        bindVal.put("createdAt", createdAt);
        Integer savePermission = this.apiDao.savePermission(bindVal, id);
        HashMap<String, String> ret = new HashMap<String, String>();
        if (savePermission < 1) {
            ret.put("sysErrorCode", "51000");
        }
        return ret;
    }

    public Map addRole(Map maps) {
        HashMap<String, String> retInfo = new HashMap<String, String>();
        String id = "";
        if (maps.containsKey("id")) {
            id = maps.get("id").toString();
        }
        String isEnable = maps.get("is_enable").toString();
        String roleName = maps.get("role_name").toString();
        String roleDesc = "";
        if (maps.containsKey("role_desc")) {
            roleDesc = maps.get("role_desc").toString();
        } else if (maps.containsKey("role_description")) {
            roleDesc = maps.get("role_description").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, Object> addRolePamars = new HashMap<String, Object>();
        addRolePamars.put("roleName", roleName);
        addRolePamars.put("isEnable", isEnable);
        addRolePamars.put("roleDesc", roleDesc);
        if (id.length() > 0) {
            addRolePamars.put("id", id);
        } else {
            addRolePamars.put("createdAt", createdAt);
        }
        Integer roleId = 0;
        if (id.length() > 0) {
            Integer editRoleRet = this.apiDao.editRole(addRolePamars);
            if (editRoleRet < 1) {
                retInfo.put("sysErrorCode", "500");
                return retInfo;
            }
            roleId = Integer.valueOf(id);
        } else {
            roleId = this.apiDao.addRole(addRolePamars);
        }
        Boolean hasPermission = maps.containsKey("permission_info");
        Integer addRolePermissionRet = 0;
        if (hasPermission.booleanValue()) {
            String allPermission = maps.get("permission_info").toString();
            LinkedHashSet<String> unPermission = new LinkedHashSet<String>();
            for (String s : allPermission.split(",")) {
                unPermission.add(s);
            }
            Object values = "";
            for (String val2 : unPermission) {
                values = (String)values + " (" + roleId + "," + val2 + "),";
            }
            values = this.commonUtil.trimFirstAndLastChar((String)values, ",");
            addRolePermissionRet = id.length() > 0 ? this.apiDao.editRolePermission((String)values, id) : this.apiDao.addRolePermission((String)values);
        }
        if (!(hasPermission.booleanValue() && addRolePermissionRet > 0 && roleId > 0 || !hasPermission.booleanValue() && roleId > 0)) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    public Map pageDetailById(Map params) {
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("page_details", id);
        return info2;
    }

    public Map permissionDetailById(Map params) {
        String isDir;
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("roma_permissions", id);
        String isVisible = info2.get("is_visible").toString();
        if (isVisible.equals("0")) {
            info2.put("is_visible", "1");
        }
        if ((isDir = info2.get("is_menu").toString()).equals("0")) {
            info2.put("is_dir", "1");
        }
        return info2;
    }

    public Map addPage(Map maps) {
        String pageDesc = "";
        String frontPath = "";
        String isEnable = "1";
        String pageCode = maps.get("page_code").toString();
        String pageName = maps.get("page_name").toString();
        String pageJson = maps.get("page_json").toString();
        if (maps.containsKey("page_desc")) {
            pageDesc = maps.get("page_desc").toString();
        } else if (maps.containsKey("page_description")) {
            pageDesc = maps.get("page_description").toString();
        }
        String editId = "";
        if (maps.containsKey("id")) {
            editId = maps.get("id").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, Object> addPagePamars = new HashMap<String, Object>();
        addPagePamars.put("frontPath", frontPath);
        addPagePamars.put("isEnable", isEnable);
        addPagePamars.put("pageCode", pageCode);
        addPagePamars.put("pageDesc", pageDesc);
        addPagePamars.put("pageName", pageName);
        addPagePamars.put("pageJson", pageJson);
        if (editId.length() == 0) {
            addPagePamars.put("createdAt", createdAt);
        }
        Integer pageId = this.apiDao.addPageDetails(addPagePamars, editId);
        HashMap<String, String> retInfo = new HashMap<String, String>();
        if (pageId <= 0) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    public Map addSql(Map maps, String authorization) {
        String sqlDesc = "";
        String isList = "0";
        if (maps.containsKey("is_list")) {
            isList = maps.get("is_list").toString();
        }
        String sqlType = maps.get("sql_type").toString();
        String isEnable = "1";
        String sqlCode = maps.get("sql_code").toString();
        String sqlName = maps.get("sql_name").toString();
        String sqlString = maps.get("sql_string").toString();
        if (maps.containsKey("sql_description")) {
            sqlDesc = maps.get("sql_description").toString();
        }
        String editId = "";
        if (maps.containsKey("id")) {
            editId = maps.get("id").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, Object> addPagePamars = new HashMap<String, Object>();
        addPagePamars.put("isList", isList);
        addPagePamars.put("sqlType", sqlType);
        addPagePamars.put("isEnable", isEnable);
        addPagePamars.put("sqlCode", sqlCode);
        addPagePamars.put("sqlName", sqlName);
        addPagePamars.put("sqlString", sqlString);
        addPagePamars.put("sqlDesc", sqlDesc);
        Map<String, Object> loginResult = this.userInfo(authorization);
        addPagePamars.put("actionUser", loginResult.get("userName"));
        if (editId.length() == 0) {
            addPagePamars.put("createdAt", createdAt);
        }
        Integer pageId = this.apiDao.addSqlDetails(addPagePamars, editId);
        HashMap<String, String> retInfo = new HashMap<String, String>();
        if (pageId <= 0) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    public Map saveApi(Map maps, String authorization) {
        String apiDesc = "";
        String isEnable = "1";
        String apiCode = maps.get("api_code").toString();
        String apiName = maps.get("api_name").toString();
        if (maps.containsKey("api_description")) {
            apiDesc = maps.get("api_description").toString();
        }
        String editId = "";
        if (maps.containsKey("id")) {
            editId = maps.get("id").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, Object> addPagePamars = new HashMap<String, Object>();
        addPagePamars.put("isEnable", isEnable);
        addPagePamars.put("apiCode", apiCode);
        addPagePamars.put("apiName", apiName);
        addPagePamars.put("apiDesc", apiDesc);
        if (editId.length() == 0) {
            addPagePamars.put("createdAt", createdAt);
        }
        Integer pageId = this.apiDao.saveApiDetails(addPagePamars, editId);
        HashMap<String, String> retInfo = new HashMap<String, String>();
        if (pageId <= 0) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    public Map apiDetailById(Map params) {
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("api_details", id);
        return info2;
    }

    public Map itemDetailById(Map params) {
        String id = params.get("id").toString();
        Map info2 = this.apiDao.getDetailsInfoByIdAndType("item_details", id);
        return info2;
    }

    public Map saveItem(Map maps, String authorization) {
        String itemDesc = "";
        String isEnable = "1";
        String itemCode = maps.get("item_code").toString();
        String itemName = maps.get("item_name").toString();
        if (maps.containsKey("item_description")) {
            itemDesc = maps.get("item_description").toString();
        }
        String editId = "";
        if (maps.containsKey("id")) {
            editId = maps.get("id").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, Object> addPagePamars = new HashMap<String, Object>();
        addPagePamars.put("isEnable", isEnable);
        addPagePamars.put("itemCode", itemCode);
        addPagePamars.put("itemName", itemName);
        addPagePamars.put("itemDesc", itemDesc);
        if (editId.length() == 0) {
            addPagePamars.put("createdAt", createdAt);
        }
        Integer pageId = this.apiDao.saveItemDetails(addPagePamars, editId);
        HashMap<String, String> retInfo = new HashMap<String, String>();
        if (pageId <= 0) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    public Map userListHasPaging(Map<String, String> maps) {
        String page = "1";
        String perPage = "15";
        HashMap<String, Object> res = new HashMap<String, Object>();
        Map bindData = this.commonUtil.filterApiBindParams(maps);
        if (maps.containsKey("page")) {
            page = maps.get("page");
        }
        if (maps.containsKey("perPage")) {
            perPage = maps.get("perPage");
        }
        Integer count = this.pageDao.getAllUserListHasPagingCount(bindData);
        List<Map<String, Object>> info2 = this.pageDao.getAllUserListHasPaging(bindData, page, perPage, count);
        res.put("count", count);
        res.put("rows", info2);
        return res;
    }

    public Map userSave(Map maps, String authorization) {
        String isEnable = maps.get("is_enable").toString();
        String adminName = maps.get("admin_name").toString();
        String userId = "";
        String adminPassword = "";
        if (maps.containsKey("id")) {
            userId = maps.get("id").toString();
        } else {
            adminPassword = maps.get("admin_password").toString();
        }
        String adminEmail = "";
        String adminPhone = "";
        String userRole = "";
        String apiUploadPic = "";
        if (maps.containsKey("admin_email")) {
            adminEmail = maps.get("admin_email").toString();
        }
        if (maps.containsKey("admin_phone")) {
            adminPhone = maps.get("admin_phone").toString();
        }
        if (maps.containsKey("api_upload_pic")) {
            apiUploadPic = maps.get("api_upload_pic").toString();
        }
        if (maps.containsKey("user_role")) {
            userRole = maps.get("user_role").toString();
        }
        String createdAt = this.commonUtil.getNowYYMMDDHHIISS();
        HashMap<String, String> addPagePamars = new HashMap<String, String>();
        adminPassword = this.securityUtils.encodePassword(adminPassword);
        addPagePamars.put("isEnable", isEnable);
        addPagePamars.put("adminName", adminName);
        addPagePamars.put("adminPassword", adminPassword);
        addPagePamars.put("adminEmail", adminEmail);
        addPagePamars.put("adminPhone", adminPhone);
        addPagePamars.put("apiUploadPic", apiUploadPic);
        if (userId.length() <= 0) {
            addPagePamars.put("createdAt", createdAt);
        }
        Integer pageId = this.apiDao.saveUser(addPagePamars, userRole, userId);
        HashMap<String, String> retInfo = new HashMap<String, String>();
        if (pageId <= 0) {
            retInfo.put("sysErrorCode", "500");
        }
        return retInfo;
    }

    private List<Map<String, Object>> treeMenu(List<Map<String, Object>> renderMenu) {
        ArrayList<Map<String, Object>> pList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> tmp : renderMenu) {
            tmp.put("hidden_user_permission", "8");
            Object parentId = tmp.get("parent_id");
            String stringParentId = parentId.toString();
            Object dataId = tmp.get("id");
            String stringDataId = dataId.toString();
            if (!stringParentId.equals("0")) continue;
            List<?> children = this.menuChild(stringDataId, renderMenu);
            if (children == null || children.size() == 0) {
                tmp.put("leaf", true);
            } else {
                tmp.put("children", children);
            }
            pList.add(tmp);
        }
        return pList;
    }

    private List<?> menuChild(String id, List<Map<String, Object>> data) {
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : data) {
            Object objectMenuName;
            String stringMenuName;
            Object parentId = map.get("parent_id");
            String stringParentId = parentId.toString();
            Object dataId = map.get("id");
            String stringDataId = dataId.toString();
            Object objectId = map.get("object_id");
            Object objectType = map.get("object_type");
            String stringObjectId = objectId.toString();
            String stringObjectType = objectType.toString();
            Map permissionDetails = this.getPermissionDetails(stringObjectType, stringObjectId, stringMenuName = (objectMenuName = map.get("menu_name")).toString());
            if (permissionDetails.containsKey("permission_path")) {
                map.put("permission_path", permissionDetails.get("permission_path"));
            }
            if (permissionDetails.containsKey("permission_name")) {
                map.put("permission_name", permissionDetails.get("permission_name"));
            }
            if (permissionDetails.containsKey("show_name")) {
                map.put("show_name", permissionDetails.get("show_name"));
            }
            if (!stringParentId.equals(id)) continue;
            List<?> children = this.menuChild(stringDataId, data);
            if (children == null || children.size() == 0) {
                map.put("leaf", true);
            } else {
                map.put("children", children);
            }
            lists.add(map);
        }
        return lists;
    }

    private Map getPermissionDetails(String stringObjectType, String stringObjectId, String stringMenuName) {
        String separator = " / ";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (stringObjectType.equals("page")) {
            if (stringObjectId.equals("0")) {
                map.put("permission_name", stringMenuName);
                map.put("show_name", stringMenuName);
            } else {
                Map pageInfo = this.apiDao.getDetailsInfoByIdAndType("page_details", stringObjectId);
                map.put("permission_path", "/page/" + String.valueOf(pageInfo.get("page_code")));
                map.put("permission_name", pageInfo.get("page_name"));
                map.put("show_name", pageInfo.get("page_code").toString() + separator + String.valueOf(pageInfo.get("page_name")));
            }
        } else if (stringObjectType.equals("sql") && !stringObjectId.equals("0")) {
            Map pageInfo = this.apiDao.getDetailsInfoByIdAndType("sql_details", stringObjectId);
            map.put("permission_path", "/dbapi/" + String.valueOf(pageInfo.get("sql_code")));
            map.put("permission_name", pageInfo.get("sql_name"));
            map.put("show_name", pageInfo.get("sql_code").toString() + separator + String.valueOf(pageInfo.get("sql_name")));
        } else if (stringObjectType.equals("api") && !stringObjectId.equals("0")) {
            Map pageInfo = this.apiDao.getDetailsInfoByIdAndType("api_details", stringObjectId);
            map.put("permission_path", "/api/" + String.valueOf(pageInfo.get("api_code")));
            map.put("permission_name", pageInfo.get("api_name"));
            map.put("show_name", pageInfo.get("api_code").toString() + separator + String.valueOf(pageInfo.get("api_name")));
        } else if (stringObjectType.equals("item") && !stringObjectId.equals("0")) {
            Map pageInfo = this.apiDao.getDetailsInfoByIdAndType("item_details", stringObjectId);
            map.put("permission_path", "/api/" + String.valueOf(pageInfo.get("item_code")));
            map.put("permission_name", pageInfo.get("item_name"));
            map.put("show_name", pageInfo.get("item_code").toString() + separator + String.valueOf(pageInfo.get("item_name")));
        }
        return map;
    }
}

