/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.service;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.roma.romaapi.utils.UUIDUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class CaptchaService {
    @Autowired
    private DefaultKaptcha producer;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private UUIDUtil uuidUtil;
    private Integer timeout = 600;

    public Map<String, Object> createToken(String captcha) {
        String key = this.uuidUtil.getUUID32();
        this.redisTemplate.opsForValue().set(key, captcha);
        this.redisTemplate.expire(key, this.timeout.intValue(), TimeUnit.MINUTES);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", key);
        map.put("expire", this.timeout);
        return map;
    }

    public Map<String, Object> captchaCreator() throws IOException {
        return this.catchaImgCreator();
    }

    public String versifyCaptcha(String token, String inputCode) {
        ValueOperations<String, String> valueOperations = this.redisTemplate.opsForValue();
        if (this.redisTemplate.hasKey(token).booleanValue()) {
            if (valueOperations.get(token).equals(inputCode)) {
                this.redisTemplate.delete(token);
                return "true";
            }
            return "false";
        }
        return "false";
    }

    public Map<String, Object> catchaImgCreator() throws IOException {
        String text = this.producer.createText();
        BufferedImage image = this.producer.createImage(text);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", outputStream);
        Map<String, Object> token = this.createToken(text);
        Base64.Encoder encoder = Base64.getEncoder();
        String base64String = encoder.encodeToString(outputStream.toByteArray());
        token.put("img", base64String);
        return token;
    }
}

