/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterreplica.RedisMasterReplicaNode;
import io.lettuce.core.masterreplica.ResumeAfter;
import io.lettuce.core.masterreplica.TopologyProvider;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.models.role.RoleParser;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class StaticMasterReplicaTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StaticMasterReplicaTopologyProvider.class);
    private final RedisClient redisClient;
    private final Iterable<RedisURI> redisURIs;

    public StaticMasterReplicaTopologyProvider(RedisClient redisClient, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        LettuceAssert.notNull((Object)redisURIs.iterator().hasNext(), "RedisURIs must not be empty");
        this.redisClient = redisClient;
        this.redisURIs = redisURIs;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        RedisURI next = this.redisURIs.iterator().next();
        try {
            return this.getNodesAsync().get(next.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public CompletableFuture<List<RedisNodeDescription>> getNodesAsync() {
        CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
        Flux<RedisURI> uris = Flux.fromIterable(this.redisURIs);
        Mono nodes = uris.flatMap(uri -> this.getNodeDescription(connections, (RedisURI)uri)).collectList().flatMap(nodeDescriptions -> {
            if (nodeDescriptions.isEmpty()) {
                return Mono.error(new RedisConnectionException(String.format("Failed to connect to at least one node in %s", this.redisURIs)));
            }
            return Mono.just(nodeDescriptions);
        });
        return nodes.toFuture();
    }

    private Mono<RedisNodeDescription> getNodeDescription(List<StatefulRedisConnection<String, String>> connections, RedisURI uri) {
        return Mono.fromCompletionStage(this.redisClient.connectAsync(StringCodec.UTF8, uri)).onErrorResume(t -> {
            logger.warn("Cannot connect to {}", (Object)uri, t);
            return Mono.empty();
        }).doOnNext(connections::add).flatMap(connection -> {
            Mono<RedisNodeDescription> instance = StaticMasterReplicaTopologyProvider.getNodeDescription(uri, connection);
            return instance.flatMap(it -> ResumeAfter.close(connection).thenEmit(it)).doFinally(s -> connections.remove(connection));
        });
    }

    private static Mono<RedisNodeDescription> getNodeDescription(RedisURI uri, StatefulRedisConnection<String, String> connection) {
        return connection.reactive().role().collectList().map(RoleParser::parse).map(it -> new RedisMasterReplicaNode(uri.getHost(), uri.getPort(), uri, it.getRole()));
    }
}

