/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.internal.LettuceSets;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.support.RedisClientCdiBean;
import io.lettuce.core.support.RedisClusterClientCdiBean;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;

public class LettuceCdiExtension
implements Extension {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(LettuceCdiExtension.class);
    private final Map<Set<Annotation>, Bean<RedisURI>> redisUris = new ConcurrentHashMap<Set<Annotation>, Bean<RedisURI>>();
    private final Map<Set<Annotation>, Bean<ClientResources>> clientResources = new ConcurrentHashMap<Set<Annotation>, Bean<ClientResources>>();

    public LettuceCdiExtension() {
        LOGGER.info("Activating CDI extension for lettuce.");
    }

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean2 = processBean.getBean();
        for (Type type : bean2.getTypes()) {
            Set qualifiers;
            if (!(type instanceof Class)) continue;
            if (RedisURI.class.isAssignableFrom((Class)type)) {
                qualifiers = LettuceSets.newHashSet(bean2.getQualifiers());
                if (bean2.isAlternative() || !this.redisUris.containsKey(qualifiers)) {
                    LOGGER.debug(String.format("Discovered '%s' with qualifiers %s.", RedisURI.class.getName(), qualifiers));
                    this.redisUris.put(qualifiers, (Bean<RedisURI>)bean2);
                }
            }
            if (!ClientResources.class.isAssignableFrom((Class)type)) continue;
            qualifiers = LettuceSets.newHashSet(bean2.getQualifiers());
            if (!bean2.isAlternative() && this.clientResources.containsKey(qualifiers)) continue;
            LOGGER.debug(String.format("Discovered '%s' with qualifiers %s.", ClientResources.class.getName(), qualifiers));
            this.clientResources.put(qualifiers, (Bean<ClientResources>)bean2);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        int counter = 0;
        for (Map.Entry<Set<Annotation>, Bean<RedisURI>> entry : this.redisUris.entrySet()) {
            Bean<RedisURI> redisUri = entry.getValue();
            Set<Annotation> qualifiers = entry.getKey();
            String clientBeanName = RedisClient.class.getSimpleName();
            String clusterClientBeanName = RedisClusterClient.class.getSimpleName();
            if (!this.containsDefault(qualifiers)) {
                clientBeanName = clientBeanName + counter;
                clusterClientBeanName = clusterClientBeanName + counter;
                ++counter;
            }
            Bean<ClientResources> clientResources = this.clientResources.get(qualifiers);
            RedisClientCdiBean clientBean = new RedisClientCdiBean(redisUri, clientResources, beanManager, qualifiers, clientBeanName);
            this.register(afterBeanDiscovery, qualifiers, clientBean);
            RedisClusterClientCdiBean clusterClientBean = new RedisClusterClientCdiBean(redisUri, clientResources, beanManager, qualifiers, clusterClientBeanName);
            this.register(afterBeanDiscovery, qualifiers, clusterClientBean);
        }
    }

    private boolean containsDefault(Set<Annotation> qualifiers) {
        return qualifiers.stream().filter(input -> input instanceof Default).findFirst().isPresent();
    }

    private void register(AfterBeanDiscovery afterBeanDiscovery, Set<Annotation> qualifiers, Bean<?> bean2) {
        LOGGER.info(String.format("Registering bean '%s' with qualifiers %s.", bean2.getBeanClass().getName(), qualifiers));
        afterBeanDiscovery.addBean(bean2);
    }
}

