/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.http.MimeHeaders;

public class FormAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(FormAuthenticator.class);
    protected String characterEncoding = null;
    protected String landingPage = null;

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @Override
    protected boolean doAuthenticate(Request request2, HttpServletResponse response) throws IOException {
        String uri;
        String expectedSessionId;
        Session session = null;
        Principal principal = null;
        if (!this.cache) {
            session = request2.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Checking for reauthenticate in session " + session);
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reauthenticating username '" + username + "'");
                }
                if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                    this.register(request2, response, principal, "FORM", username, password);
                    if (!this.matchRequest(request2)) {
                        return true;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request2)) {
            session = request2.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Restore request from session '" + session.getIdInternal() + "'");
            }
            if (this.restoreRequest(request2, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Proceed to restored request");
                }
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Restore of original request failed");
            }
            response.sendError(400);
            return false;
        }
        if (this.checkForCachedAuthentication(request2, response, true)) {
            return true;
        }
        String contextPath = request2.getContextPath();
        String requestURI = request2.getDecodedRequestURI();
        boolean loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        LoginConfig config = this.context.getLoginConfig();
        if (!loginAction) {
            if (request2.getServletPath().length() == 0 && request2.getPathInfo() == null) {
                StringBuilder location = new StringBuilder(requestURI);
                location.append('/');
                if (request2.getQueryString() != null) {
                    location.append('?');
                    location.append(request2.getQueryString());
                }
                response.sendRedirect(response.encodeRedirectURL(location.toString()));
                return false;
            }
            session = request2.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Save request in session '" + session.getIdInternal() + "'");
            }
            try {
                this.saveRequest(request2, session);
            }
            catch (IOException ioe) {
                this.log.debug("Request body too big to save during authentication");
                response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            this.forwardToLoginPage(request2, response, config);
            return false;
        }
        request2.getResponse().sendAcknowledgement(ContinueResponseTiming.ALWAYS);
        Realm realm = this.context.getRealm();
        if (this.characterEncoding != null) {
            request2.setCharacterEncoding(this.characterEncoding);
        }
        String username = request2.getParameter("j_username");
        String password = request2.getParameter("j_password");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authenticating username '" + username + "'");
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request2, response, config);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication of '" + username + "' was successful");
        }
        if (session == null) {
            session = request2.getSessionInternal(false);
        }
        if (session != null && this.getChangeSessionIdOnAuthentication() && ((expectedSessionId = (String)session.getNote("org.apache.catalina.authenticator.SESSION_ID")) == null || !expectedSessionId.equals(request2.getRequestedSessionId()))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("formAuthenticator.sessionIdMismatch", session.getId(), expectedSessionId));
            }
            session.expire();
            session = null;
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("User took so long to log on the session expired");
            }
            if (this.landingPage == null) {
                response.sendError(408, sm.getString("authenticator.sessionExpired"));
            } else {
                uri = request2.getContextPath() + this.landingPage;
                SavedRequest saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                saved.setDecodedRequestURI(uri);
                request2.getSessionInternal(true).setNote("org.apache.catalina.authenticator.REQUEST", saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
            return false;
        }
        this.register(request2, response, principal, "FORM", username, password);
        requestURI = this.savedRequestURL(session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirecting to original '" + requestURI + "'");
        }
        if (requestURI == null) {
            if (this.landingPage == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                uri = request2.getContextPath() + this.landingPage;
                SavedRequest saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                saved.setDecodedRequestURI(uri);
                session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
        } else {
            Response internalResponse = request2.getResponse();
            String location = response.encodeRedirectURL(requestURI);
            if ("HTTP/1.1".equals(request2.getProtocol())) {
                internalResponse.sendRedirect(location, 303);
            } else {
                internalResponse.sendRedirect(location, 302);
            }
        }
        return false;
    }

    @Override
    protected boolean isContinuationRequired(Request request2) {
        SavedRequest savedRequest;
        String contextPath = this.context.getPath();
        String decodedRequestURI = request2.getDecodedRequestURI();
        if (decodedRequestURI.startsWith(contextPath) && decodedRequestURI.endsWith("/j_security_check")) {
            return true;
        }
        Session session = request2.getSessionInternal(false);
        return session != null && (savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST")) != null && decodedRequestURI.equals(savedRequest.getDecodedRequestURI());
    }

    @Override
    protected String getAuthMethod() {
        return "FORM";
    }

    @Override
    protected void register(Request request2, HttpServletResponse response, Principal principal, String authType, String username, String password, boolean alwaysUseSession, boolean cache) {
        Session session;
        super.register(request2, response, principal, authType, username, password, alwaysUseSession, cache);
        if (!cache && (session = request2.getSessionInternal(false)) != null) {
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToLoginPage(Request request2, HttpServletResponse response, LoginConfig config) throws IOException {
        Session session;
        String loginPage;
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("formAuthenticator.forwardLogin", request2.getRequestURI(), request2.getMethod(), config.getLoginPage(), this.context.getName()));
        }
        if ((loginPage = config.getLoginPage()) == null || loginPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noLoginPage", this.context.getName());
            this.log.warn(msg);
            response.sendError(500, msg);
            return;
        }
        if (this.getChangeSessionIdOnAuthentication() && (session = request2.getSessionInternal(false)) != null) {
            String oldSessionId = session.getId();
            String newSessionId = this.changeSessionID(request2, session);
            session.setNote("org.apache.catalina.authenticator.SESSION_ID", newSessionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("formAuthenticator.changeSessionIdLogin", oldSessionId, newSessionId));
            }
        }
        String oldMethod = request2.getMethod();
        request2.getCoyoteRequest().method().setString("GET");
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(loginPage);
        try {
            if (this.context.fireRequestInitEvent(request2.getRequest())) {
                disp.forward(request2.getRequest(), response);
                this.context.fireRequestDestroyEvent(request2.getRequest());
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            String msg = sm.getString("formAuthenticator.forwardLoginFail");
            this.log.warn(msg, t);
            request2.setAttribute("jakarta.servlet.error.exception", t);
            response.sendError(500, msg);
        }
        finally {
            request2.getCoyoteRequest().method().setString(oldMethod);
        }
    }

    protected void forwardToErrorPage(Request request2, HttpServletResponse response, LoginConfig config) throws IOException {
        String errorPage = config.getErrorPage();
        if (errorPage == null || errorPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noErrorPage", this.context.getName());
            this.log.warn(msg);
            response.sendError(500, msg);
            return;
        }
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
        try {
            if (this.context.fireRequestInitEvent(request2.getRequest())) {
                disp.forward(request2.getRequest(), response);
                this.context.fireRequestDestroyEvent(request2.getRequest());
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            String msg = sm.getString("formAuthenticator.forwardErrorFail");
            this.log.warn(msg, t);
            request2.setAttribute("jakarta.servlet.error.exception", t);
            response.sendError(500, msg);
        }
    }

    protected boolean matchRequest(Request request2) {
        String expectedSessionId;
        Session session = request2.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (this.cache && session.getPrincipal() == null || !this.cache && request2.getPrincipal() == null) {
            return false;
        }
        if (this.getChangeSessionIdOnAuthentication() && ((expectedSessionId = (String)session.getNote("org.apache.catalina.authenticator.SESSION_ID")) == null || !expectedSessionId.equals(request2.getRequestedSessionId()))) {
            return false;
        }
        String decodedRequestURI = request2.getDecodedRequestURI();
        if (decodedRequestURI == null) {
            return false;
        }
        return decodedRequestURI.equals(sreq.getDecodedRequestURI());
    }

    protected boolean restoreRequest(Request request2, Session session) throws IOException {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.SESSION_ID");
        if (saved == null) {
            return false;
        }
        byte[] buffer = new byte[4096];
        ServletInputStream is = request2.createInputStream();
        while (is.read(buffer) >= 0) {
        }
        request2.clearCookies();
        Iterator<Cookie> cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request2.addCookie(cookies.next());
        }
        String method = saved.getMethod();
        MimeHeaders rmh = request2.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cacheable = "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
        Iterator<String> names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cacheable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator<String> values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString(values.next());
            }
        }
        request2.clearLocales();
        Iterator<Locale> locales = saved.getLocales();
        while (locales.hasNext()) {
            request2.addLocale(locales.next());
        }
        request2.getCoyoteRequest().getParameters().recycle();
        ByteChunk body2 = saved.getBody();
        if (body2 != null) {
            request2.getCoyoteRequest().action(ActionCode.REQ_SET_BODY_REPLAY, body2);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null && "POST".equalsIgnoreCase(method)) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request2.getCoyoteRequest().setContentType(contentType);
        }
        request2.getCoyoteRequest().method().setString(method);
        request2.getRequestURI();
        request2.getQueryString();
        request2.getProtocol();
        return true;
    }

    protected void saveRequest(Request request2, Session session) throws IOException {
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request2.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                saved.addCookie(cookie);
            }
        }
        Enumeration<String> names = request2.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request2.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration<Locale> locales = request2.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            saved.addLocale(locale);
        }
        request2.getResponse().sendAcknowledgement(ContinueResponseTiming.ALWAYS);
        int maxSavePostSize = request2.getConnector().getMaxSavePostSize();
        if (maxSavePostSize != 0) {
            int bytesRead;
            ByteChunk body2 = new ByteChunk();
            body2.setLimit(maxSavePostSize);
            byte[] buffer = new byte[4096];
            ServletInputStream is = request2.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                body2.append(buffer, 0, bytesRead);
            }
            if (body2.getLength() > 0) {
                saved.setContentType(request2.getContentType());
                saved.setBody(body2);
            }
        }
        saved.setMethod(request2.getMethod());
        saved.setQueryString(request2.getQueryString());
        saved.setRequestURI(request2.getRequestURI());
        saved.setDecodedRequestURI(request2.getDecodedRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }
}

