/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.json;

public class JSONFilter {
    private JSONFilter() {
    }

    public static String escape(String input) {
        char[] chars = input.toCharArray();
        StringBuffer escaped = null;
        int lastUnescapedStart = 0;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] >= ' ' && chars[i2] != '\"' && chars[i2] != '\\') continue;
            if (escaped == null) {
                escaped = new StringBuffer(chars.length + 20);
            }
            if (lastUnescapedStart < i2) {
                escaped.append(input.subSequence(lastUnescapedStart, i2));
            }
            lastUnescapedStart = i2 + 1;
            escaped.append("\\u");
            escaped.append(String.format("%04X", chars[i2]));
        }
        if (escaped == null) {
            return input;
        }
        if (lastUnescapedStart < chars.length) {
            escaped.append(input.subSequence(lastUnescapedStart, chars.length));
        }
        return escaped.toString();
    }
}

