/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeCanonicalPath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEmptyDirectory;
import org.assertj.core.error.ShouldBeExecutable;
import org.assertj.core.error.ShouldBeNormalized;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRegularFile;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeSymbolicLink;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainRecursively;
import org.assertj.core.error.ShouldEndWithPath;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveExtension;
import org.assertj.core.error.ShouldHaveFileSystem;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoExtension;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldHaveSameFileSystemAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.error.ShouldStartWithPath;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Files;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class Paths {
    private static final String UNABLE_TO_COMPARE_PATH_CONTENTS = "Unable to compare contents of paths:<%s> and:<%s>";
    private static final Paths INSTANCE = new Paths();
    private static final DirectoryStream.Filter<Path> ANY = any -> true;
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    NioFilesWrapper nioFilesWrapper = NioFilesWrapper.instance();

    public static Paths instance() {
        return INSTANCE;
    }

    private Paths() {
    }

    public void assertIsReadable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!java.nio.file.Files.isReadable(actual)) {
            throw this.failures.failure(info2, ShouldBeReadable.shouldBeReadable(actual));
        }
    }

    public void assertIsWritable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!java.nio.file.Files.isWritable(actual)) {
            throw this.failures.failure(info2, ShouldBeWritable.shouldBeWritable(actual));
        }
    }

    public void assertIsExecutable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!java.nio.file.Files.isExecutable(actual)) {
            throw this.failures.failure(info2, ShouldBeExecutable.shouldBeExecutable(actual));
        }
    }

    public void assertExists(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!java.nio.file.Files.exists(actual, new LinkOption[0])) {
            throw this.failures.failure(info2, ShouldExist.shouldExist(actual));
        }
    }

    public void assertExistsNoFollowLinks(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!java.nio.file.Files.exists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info2, ShouldExist.shouldExistNoFollowLinks(actual));
        }
    }

    public void assertDoesNotExist(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!java.nio.file.Files.notExists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info2, ShouldNotExist.shouldNotExist(actual));
        }
    }

    public void assertIsRegularFile(AssertionInfo info2, Path actual) {
        this.assertExists(info2, actual);
        if (!java.nio.file.Files.isRegularFile(actual, new LinkOption[0])) {
            throw this.failures.failure(info2, ShouldBeRegularFile.shouldBeRegularFile(actual));
        }
    }

    public void assertIsDirectory(AssertionInfo info2, Path actual) {
        this.assertExists(info2, actual);
        if (!java.nio.file.Files.isDirectory(actual, new LinkOption[0])) {
            throw this.failures.failure(info2, ShouldBeDirectory.shouldBeDirectory(actual));
        }
    }

    public void assertIsSymbolicLink(AssertionInfo info2, Path actual) {
        this.assertExistsNoFollowLinks(info2, actual);
        if (!java.nio.file.Files.isSymbolicLink(actual)) {
            throw this.failures.failure(info2, ShouldBeSymbolicLink.shouldBeSymbolicLink(actual));
        }
    }

    public void assertIsAbsolute(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!actual.isAbsolute()) {
            throw this.failures.failure(info2, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
        }
    }

    public void assertIsRelative(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (actual.isAbsolute()) {
            throw this.failures.failure(info2, ShouldBeRelativePath.shouldBeRelativePath(actual));
        }
    }

    public void assertIsNormalized(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!actual.normalize().equals(actual)) {
            throw this.failures.failure(info2, ShouldBeNormalized.shouldBeNormalized(actual));
        }
    }

    public void assertIsCanonical(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!actual.equals(Paths.toRealPath(actual))) {
            throw this.failures.failure(info2, ShouldBeCanonicalPath.shouldBeCanonicalPath(actual));
        }
    }

    public void assertHasParent(AssertionInfo info2, Path actual, Path expected) {
        Paths.assertNotNull(info2, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        Path parent = Paths.toRealPath(actual).getParent();
        if (parent == null) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!parent.equals(Paths.toRealPath(expected))) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, parent, expected));
        }
    }

    public void assertHasParentRaw(AssertionInfo info2, Path actual, Path expected) {
        Paths.assertNotNull(info2, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        Path parent = actual.getParent();
        if (parent == null) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!parent.equals(expected)) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, parent, expected));
        }
    }

    public void assertHasNoParent(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (Paths.toRealPath(actual).getParent() != null) {
            throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
        }
    }

    public void assertHasNoParentRaw(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (actual.getParent() != null) {
            throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
        }
    }

    public void assertHasSize(AssertionInfo info2, Path actual, long expectedSize) {
        this.assertIsRegularFile(info2, actual);
        try {
            long actualSize = this.nioFilesWrapper.size(actual);
            if (actualSize != expectedSize) {
                throw this.failures.failure(info2, ShouldHaveSize.shouldHaveSize(actual, expectedSize));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertStartsWith(AssertionInfo info2, Path actual, Path other) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedStartPathIsNotNull(other);
        if (!Paths.toRealPath(actual).startsWith(Paths.toRealPath(other))) {
            throw this.failures.failure(info2, ShouldStartWithPath.shouldStartWith(actual, other));
        }
    }

    public void assertStartsWithRaw(AssertionInfo info2, Path actual, Path other) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedStartPathIsNotNull(other);
        if (!actual.startsWith(other)) {
            throw this.failures.failure(info2, ShouldStartWithPath.shouldStartWith(actual, other));
        }
    }

    public void assertEndsWith(AssertionInfo info2, Path actual, Path other) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedEndPathIsNotNull(other);
        if (!Paths.toRealPath(actual).endsWith(other.normalize())) {
            throw this.failures.failure(info2, ShouldEndWithPath.shouldEndWith(actual, other));
        }
    }

    public void assertEndsWithRaw(AssertionInfo info2, Path actual, Path end) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedEndPathIsNotNull(end);
        if (!actual.endsWith(end)) {
            throw this.failures.failure(info2, ShouldEndWithPath.shouldEndWith(actual, end));
        }
    }

    public void assertHasFileName(AssertionInfo info2, Path actual, String fileName) {
        Paths.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(fileName, "expected fileName should not be null");
        if (!actual.getFileName().endsWith(fileName)) {
            throw this.failures.failure(info2, ShouldHaveName.shouldHaveName(actual, fileName));
        }
    }

    public void assertHasTextualContent(AssertionInfo info2, Path actual, String expected, Charset charset) {
        java.util.Objects.requireNonNull(expected, "The text to compare to should not be null");
        this.assertIsReadable(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (!diffs.isEmpty()) {
                throw this.failures.failure(info2, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify text contents of path:<%s>", actual), e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info2, Path actual, byte[] expected) {
        java.util.Objects.requireNonNull(expected, "The binary content to compare to should not be null");
        this.assertIsReadable(info2, actual);
        try {
            BinaryDiffResult diffResult = this.binaryDiff.diff(actual, expected);
            if (!diffResult.hasNoDiff()) {
                throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, diffResult));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify binary contents of path:<%s>", actual), e);
        }
    }

    public void assertHasSameBinaryContentAs(AssertionInfo info2, Path actual, Path expected) {
        java.util.Objects.requireNonNull(expected, "The given Path to compare actual content to should not be null");
        Preconditions.checkArgument(java.nio.file.Files.exists(expected, new LinkOption[0]), "The given Path <%s> to compare actual content to should exist", expected);
        Preconditions.checkArgument(java.nio.file.Files.isReadable(expected), "The given Path <%s> to compare actual content to should be readable", expected);
        this.assertIsReadable(info2, actual);
        try {
            BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected));
            if (binaryDiffResult.hasDiff()) {
                throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_PATH_CONTENTS, actual, expected), ioe);
        }
    }

    public void assertHasSameTextualContentAs(AssertionInfo info2, Path actual, Charset actualCharset, Path expected, Charset expectedCharset) {
        java.util.Objects.requireNonNull(expected, "The given Path to compare actual content to should not be null");
        Preconditions.checkArgument(java.nio.file.Files.exists(expected, new LinkOption[0]), "The given Path <%s> to compare actual content to should exist", expected);
        Preconditions.checkArgument(java.nio.file.Files.isReadable(expected), "The given Path <%s> to compare actual content to should be readable", expected);
        this.assertIsReadable(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (!diffs.isEmpty()) {
                throw this.failures.failure(info2, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_PATH_CONTENTS, actual, expected), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, MessageDigest digest, byte[] expected) {
        java.util.Objects.requireNonNull(digest, "The message digest algorithm should not be null");
        java.util.Objects.requireNonNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertIsRegularFile(info2, actual);
        this.assertIsReadable(info2, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual, new OpenOption[0]);){
            DigestDiff diff = Digests.digestDiff(actualStream, digest, expected);
            if (diff.digestsDiffer()) {
                throw this.failures.failure(info2, ShouldHaveDigest.shouldHaveDigest(actual, diff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, MessageDigest digest, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, String algorithm, byte[] expected) {
        java.util.Objects.requireNonNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info2, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, String algorithm, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, algorithm, Digests.fromHex(expected));
    }

    public void assertIsDirectoryContaining(AssertionInfo info2, Path actual, Predicate<Path> filter2) {
        java.util.Objects.requireNonNull(filter2, "The paths filter should not be null");
        this.assertIsDirectoryContaining(info2, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryContaining(AssertionInfo info2, Path actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        PathMatcher pathMatcher = this.pathMatcher(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryContaining(info2, actual, pathMatcher::matches, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, Path actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        PathMatcher pathMatcher = this.pathMatcher(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryRecursivelyContaining(info2, actual, pathMatcher::matches, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, Path actual, Predicate<Path> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryRecursivelyContaining(info2, actual, filter2, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info2, Path actual, Predicate<Path> filter2) {
        java.util.Objects.requireNonNull(filter2, "The paths filter should not be null");
        this.assertIsDirectoryNotContaining(info2, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info2, Path actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        PathMatcher pathMatcher = this.pathMatcher(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryNotContaining(info2, actual, pathMatcher::matches, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsEmptyDirectory(AssertionInfo info2, Path actual) {
        List<Path> items = this.directoryContent(info2, actual);
        if (!items.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeEmptyDirectory.shouldBeEmptyDirectory(actual, items));
        }
    }

    public void assertIsNotEmptyDirectory(AssertionInfo info2, Path actual) {
        boolean isEmptyDirectory = this.directoryContent(info2, actual).isEmpty();
        if (isEmptyDirectory) {
            throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty(actual));
        }
    }

    public void assertIsEmptyFile(AssertionInfo info2, Path actual) {
        this.assertIsRegularFile(info2, actual);
        try {
            if (this.nioFilesWrapper.size(actual) > 0L) {
                throw this.failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(actual));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertIsNotEmptyFile(AssertionInfo info2, Path actual) {
        this.assertIsRegularFile(info2, actual);
        try {
            if (this.nioFilesWrapper.size(actual) == 0L) {
                throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty(actual));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertHasFileSystem(AssertionInfo info2, Path actual, FileSystem expectedFileSystem) {
        Paths.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(expectedFileSystem, "The expected file system should not be null");
        FileSystem actualFileSystem = actual.getFileSystem();
        java.util.Objects.requireNonNull(actualFileSystem, "The actual file system should not be null");
        if (!expectedFileSystem.equals(actualFileSystem)) {
            throw this.failures.failure(info2, ShouldHaveFileSystem.shouldHaveFileSystem(actual, expectedFileSystem), actualFileSystem, expectedFileSystem);
        }
    }

    public void assertHasSameFileSystemAs(AssertionInfo info2, Path actualPath, Path expectedPath) {
        Paths.assertNotNull(info2, actualPath);
        java.util.Objects.requireNonNull(expectedPath, "The expected path should not be null");
        FileSystem actualFileSystem = actualPath.getFileSystem();
        java.util.Objects.requireNonNull(actualFileSystem, "The actual file system should not be null");
        FileSystem expectedFileSystem = expectedPath.getFileSystem();
        java.util.Objects.requireNonNull(expectedFileSystem, "The expected file system should not be null");
        if (!expectedFileSystem.equals(actualFileSystem)) {
            throw this.failures.failure(info2, ShouldHaveSameFileSystemAs.shouldHaveSameFileSystemAs(actualPath, expectedPath), actualFileSystem, expectedFileSystem);
        }
    }

    private List<Path> filterDirectory(AssertionInfo info2, Path actual, DirectoryStream.Filter<Path> filter2) {
        List<Path> list;
        block8: {
            this.assertIsDirectory(info2, actual);
            DirectoryStream<Path> stream = this.nioFilesWrapper.newDirectoryStream(actual, filter2);
            try {
                list = StreamSupport.stream(stream.spliterator(), false).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Unable to list directory content: <%s>", actual), e);
                }
            }
            stream.close();
        }
        return list;
    }

    private List<Path> directoryContent(AssertionInfo info2, Path actual) {
        return this.filterDirectory(info2, actual, ANY);
    }

    private void assertIsDirectoryContaining(AssertionInfo info2, Path actual, DirectoryStream.Filter<Path> filter2, String filterPresentation) {
        List<Path> matchingFiles = this.filterDirectory(info2, actual, filter2);
        if (matchingFiles.isEmpty()) {
            throw this.failures.failure(info2, ShouldContain.directoryShouldContain(actual, this.directoryContent(info2, actual), filterPresentation));
        }
    }

    private boolean isDirectoryRecursivelyContaining(AssertionInfo info2, Path actual, Predicate<Path> filter2) {
        this.assertIsDirectory(info2, actual);
        try (Stream<Path> actualContent = this.recursiveContentOf(actual);){
            boolean bl = actualContent.anyMatch(filter2);
            return bl;
        }
    }

    private List<Path> sortedRecursiveContent(Path path) {
        try (Stream<Path> pathContent = this.recursiveContentOf(path);){
            List<Path> list = pathContent.sorted().collect(Collectors.toList());
            return list;
        }
    }

    private Stream<Path> recursiveContentOf(Path directory) {
        try {
            return java.nio.file.Files.walk(directory, new FileVisitOption[0]).filter(p -> !p.equals(directory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to walk recursively the directory :<%s>", directory), e);
        }
    }

    private void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, Path actual, Predicate<Path> filter2, String filterPresentation) {
        if (!this.isDirectoryRecursivelyContaining(info2, actual, filter2)) {
            throw this.failures.failure(info2, ShouldContainRecursively.directoryShouldContainRecursively(actual, this.sortedRecursiveContent(actual), filterPresentation));
        }
    }

    private void assertIsDirectoryNotContaining(AssertionInfo info2, Path actual, DirectoryStream.Filter<Path> filter2, String filterPresentation) {
        List<Path> matchingPaths = this.filterDirectory(info2, actual, filter2);
        if (matchingPaths.size() > 0) {
            throw this.failures.failure(info2, ShouldNotContain.directoryShouldNotContain(actual, matchingPaths, filterPresentation));
        }
    }

    private PathMatcher pathMatcher(AssertionInfo info2, Path actual, String syntaxAndPattern) {
        Paths.assertNotNull(info2, actual);
        return actual.getFileSystem().getPathMatcher(syntaxAndPattern);
    }

    private static void assertNotNull(AssertionInfo info2, Path actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private static void checkExpectedParentPathIsNotNull(Path expected) {
        java.util.Objects.requireNonNull(expected, "expected parent path should not be null");
    }

    private static void assertExpectedStartPathIsNotNull(Path start) {
        java.util.Objects.requireNonNull(start, "the expected start path should not be null");
    }

    private static void assertExpectedEndPathIsNotNull(Path end) {
        java.util.Objects.requireNonNull(end, "the expected end path should not be null");
    }

    private static Path toRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertHasExtension(AssertionInfo info2, Path actual, String expected) {
        java.util.Objects.requireNonNull(expected, "The expected extension should not be null.");
        this.assertIsRegularFile(info2, actual);
        String extension = Paths.getExtension(actual).orElseThrow(() -> this.failures.failure(info2, ShouldHaveExtension.shouldHaveExtension(actual, expected)));
        if (!expected.equals(extension)) {
            throw this.failures.failure(info2, ShouldHaveExtension.shouldHaveExtension(actual, extension, expected));
        }
    }

    public void assertHasNoExtension(AssertionInfo info2, Path actual) {
        this.assertIsRegularFile(info2, actual);
        Optional<String> extension = Paths.getExtension(actual);
        if (extension.isPresent()) {
            throw this.failures.failure(info2, ShouldHaveNoExtension.shouldHaveNoExtension(actual, extension.get()));
        }
    }

    private static Optional<String> getExtension(Path path) {
        String fileName = path.getFileName().toString();
        return Files.getFileNameExtension(fileName);
    }
}

