/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldBeEqualToWithSortedQueryParameters;
import org.assertj.core.error.uri.ShouldHaveAnchor;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHaveNoHost;
import org.assertj.core.error.uri.ShouldHaveParameter;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveProtocol;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Uris;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Urls {
    private static final Urls INSTANCE = new Urls();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Urls instance() {
        return INSTANCE;
    }

    Urls() {
    }

    private static String extractNonQueryParams(URL url) {
        String queryPart = url.getQuery() == null ? "" : url.getQuery();
        return url.toString().replace(queryPart, " ");
    }

    private static String[] extractSortedQueryParams(URL url) {
        Object[] queryParams = (url.getQuery() == null ? "" : url.getQuery()).split("&");
        Arrays.sort(queryParams);
        return queryParams;
    }

    public void assertHasProtocol(AssertionInfo info2, URL actual, String protocol) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.equals(actual.getProtocol(), protocol)) {
            throw this.failures.failure(info2, ShouldHaveProtocol.shouldHaveProtocol(actual, protocol));
        }
    }

    public void assertHasPath(AssertionInfo info2, URL actual, String path) {
        Comparables.assertNotNull(info2, actual);
        Preconditions.checkArgument(path != null, "Expecting given path not to be null", new Object[0]);
        if (!Objects.equals(actual.getPath(), path)) {
            throw this.failures.failure(info2, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info2, URL actual, int expected) {
        Comparables.assertNotNull(info2, actual);
        if (actual.getPort() != expected) {
            throw this.failures.failure(info2, ShouldHavePort.shouldHavePort(actual, expected));
        }
    }

    public void assertHasHost(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        Objects.requireNonNull(expected, "The expected host should not be null");
        if (!Objects.equals(actual.getHost(), expected)) {
            throw this.failures.failure(info2, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasNoHost(AssertionInfo info2, URL actual) {
        Comparables.assertNotNull(info2, actual);
        if (actual.getHost() != null && !actual.getHost().isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveNoHost.shouldHaveNoHost(actual));
        }
    }

    public void assertHasAuthority(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.equals(actual.getAuthority(), expected)) {
            throw this.failures.failure(info2, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.equals(actual.getQuery(), expected)) {
            throw this.failures.failure(info2, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasAnchor(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.equals(actual.getRef(), expected)) {
            throw this.failures.failure(info2, ShouldHaveAnchor.shouldHaveAnchor(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.equals(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info2, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }

    public void assertHasParameter(AssertionInfo info2, URL actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, name));
        }
    }

    public void assertHasParameter(AssertionInfo info2, URL actual, String expectedParameterName, String expectedParameterValue) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(expectedParameterName)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue));
        }
        List<String> values = parameters.get(expectedParameterName);
        if (!values.contains(expectedParameterValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue, values));
        }
    }

    public void assertHasNoParameters(AssertionInfo info2, URL actual) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameters(actual, parameters.keySet()));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URL actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, parameters.get(name)));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URL actual, String name, String unwantedValue) {
        List<String> values;
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name) && (values = parameters.get(name)).contains(unwantedValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, unwantedValue, values));
        }
    }

    public void assertIsEqualToWithSortedQueryParameters(AssertionInfo info2, URL actual, URL expected) {
        boolean differentSortedQueryParams;
        Comparables.assertNotNull(info2, actual);
        boolean differentNonQueryParams = !Urls.extractNonQueryParams(expected).equals(Urls.extractNonQueryParams(actual));
        boolean bl = differentSortedQueryParams = !Objects.deepEquals(Urls.extractSortedQueryParams(expected), Urls.extractSortedQueryParams(actual));
        if (differentNonQueryParams || differentSortedQueryParams) {
            throw this.failures.failure(info2, ShouldBeEqualToWithSortedQueryParameters.shouldBeEqualToWithSortedQueryParameters(actual, expected));
        }
    }
}

