/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert.comparator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.skyscreamer.jsonassert.comparator.JSONCompareUtil;

public abstract class AbstractComparator
implements JSONComparator {
    @Override
    public final JSONCompareResult compareJSON(JSONObject expected, JSONObject actual) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        this.compareJSON("", expected, actual, result);
        return result;
    }

    @Override
    public final JSONCompareResult compareJSON(JSONArray expected, JSONArray actual) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        this.compareJSONArray("", expected, actual, result);
        return result;
    }

    protected void checkJsonObjectKeysActualInExpected(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) {
        Set<String> actualKeys = JSONCompareUtil.getKeys(actual);
        for (String key : actualKeys) {
            if (expected.has(key)) continue;
            result.unexpected(prefix, key);
        }
    }

    protected void checkJsonObjectKeysExpectedInActual(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) throws JSONException {
        Set<String> expectedKeys = JSONCompareUtil.getKeys(expected);
        for (String key : expectedKeys) {
            Object expectedValue = expected.get(key);
            if (actual.has(key)) {
                Object actualValue = actual.get(key);
                this.compareValues(JSONCompareUtil.qualify(prefix, key), expectedValue, actualValue, result);
                continue;
            }
            result.missing(prefix, key);
        }
    }

    protected void compareJSONArrayOfJsonObjects(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        String uniqueKey = JSONCompareUtil.findUniqueKey(expected);
        if (uniqueKey == null || !JSONCompareUtil.isUsableAsUniqueKey(uniqueKey, actual)) {
            this.recursivelyCompareJSONArray(key, expected, actual, result);
            return;
        }
        Map<Object, JSONObject> expectedValueMap = JSONCompareUtil.arrayOfJsonObjectToMap(expected, uniqueKey);
        Map<Object, JSONObject> actualValueMap = JSONCompareUtil.arrayOfJsonObjectToMap(actual, uniqueKey);
        for (Object id : expectedValueMap.keySet()) {
            if (!actualValueMap.containsKey(id)) {
                result.missing(JSONCompareUtil.formatUniqueKey(key, uniqueKey, id), expectedValueMap.get(id));
                continue;
            }
            JSONObject expectedValue = expectedValueMap.get(id);
            JSONObject actualValue = actualValueMap.get(id);
            this.compareValues(JSONCompareUtil.formatUniqueKey(key, uniqueKey, id), expectedValue, actualValue, result);
        }
        for (Object id : actualValueMap.keySet()) {
            if (expectedValueMap.containsKey(id)) continue;
            result.unexpected(JSONCompareUtil.formatUniqueKey(key, uniqueKey, id), actualValueMap.get(id));
        }
    }

    protected void compareJSONArrayOfSimpleValues(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        Map<Object, Integer> expectedCount = JSONCompareUtil.getCardinalityMap(JSONCompareUtil.jsonArrayToList(expected));
        Map<Object, Integer> actualCount = JSONCompareUtil.getCardinalityMap(JSONCompareUtil.jsonArrayToList(actual));
        for (Object o : expectedCount.keySet()) {
            if (!actualCount.containsKey(o)) {
                result.missing(key + "[]", o);
                continue;
            }
            if (actualCount.get(o).equals(expectedCount.get(o))) continue;
            result.fail(key + "[]: Expected " + expectedCount.get(o) + " occurrence(s) of " + o + " but got " + actualCount.get(o) + " occurrence(s)");
        }
        for (Object o : actualCount.keySet()) {
            if (expectedCount.containsKey(o)) continue;
            result.unexpected(key + "[]", o);
        }
    }

    protected void compareJSONArrayWithStrictOrder(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        for (int i2 = 0; i2 < expected.length(); ++i2) {
            Object expectedValue = JSONCompareUtil.getObjectOrNull(expected, i2);
            Object actualValue = JSONCompareUtil.getObjectOrNull(actual, i2);
            this.compareValues(key + "[" + i2 + "]", expectedValue, actualValue, result);
        }
    }

    protected void recursivelyCompareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        HashSet<Integer> matched = new HashSet<Integer>();
        for (int i2 = 0; i2 < expected.length(); ++i2) {
            Object expectedElement = JSONCompareUtil.getObjectOrNull(expected, i2);
            boolean matchFound = false;
            for (int j = 0; j < actual.length(); ++j) {
                Object actualElement = JSONCompareUtil.getObjectOrNull(actual, j);
                if (expectedElement == actualElement) {
                    matchFound = true;
                    break;
                }
                if (expectedElement == null && actualElement != null || expectedElement != null && actualElement == null || matched.contains(j) || !actualElement.getClass().equals(expectedElement.getClass())) continue;
                if (expectedElement instanceof JSONObject) {
                    if (!this.compareJSON((JSONObject)expectedElement, (JSONObject)actualElement).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (expectedElement instanceof JSONArray) {
                    if (!this.compareJSON((JSONArray)expectedElement, (JSONArray)actualElement).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (!expectedElement.equals(actualElement)) continue;
                matched.add(j);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            result.fail(key + "[" + i2 + "] Could not find match for element " + expectedElement);
            return;
        }
    }
}

