/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.saml2;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.saml2.RegistrationConfiguredCondition;
import org.springframework.boot.autoconfigure.security.saml2.Saml2RelyingPartyProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Conditional(value={RegistrationConfiguredCondition.class})
@ConditionalOnMissingBean(value={RelyingPartyRegistrationRepository.class})
class Saml2RelyingPartyRegistrationConfiguration {
    Saml2RelyingPartyRegistrationConfiguration() {
    }

    @Bean
    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(Saml2RelyingPartyProperties properties) {
        List<RelyingPartyRegistration> registrations = properties.getRegistration().entrySet().stream().map(this::asRegistration).toList();
        return new InMemoryRelyingPartyRegistrationRepository(registrations);
    }

    private RelyingPartyRegistration asRegistration(Map.Entry<String, Saml2RelyingPartyProperties.Registration> entry) {
        return this.asRegistration(entry.getKey(), entry.getValue());
    }

    private RelyingPartyRegistration asRegistration(String id, Saml2RelyingPartyProperties.Registration properties) {
        boolean usingMetadata = StringUtils.hasText(properties.getAssertingparty().getMetadataUri());
        RelyingPartyRegistration.Builder builder = usingMetadata ? RelyingPartyRegistrations.fromMetadataLocation((String)properties.getAssertingparty().getMetadataUri()).registrationId(id) : RelyingPartyRegistration.withRegistrationId((String)id);
        builder.assertionConsumerServiceLocation(properties.getAcs().getLocation());
        builder.assertionConsumerServiceBinding(properties.getAcs().getBinding());
        builder.assertingPartyDetails(this.mapAssertingParty(properties.getAssertingparty(), usingMetadata));
        builder.signingX509Credentials(credentials -> properties.getSigning().getCredentials().stream().map(this::asSigningCredential).forEach(credentials::add));
        builder.decryptionX509Credentials(credentials -> properties.getDecryption().getCredentials().stream().map(this::asDecryptionCredential).forEach(credentials::add));
        builder.assertingPartyDetails(details -> details.verificationX509Credentials(credentials -> properties.getAssertingparty().getVerification().getCredentials().stream().map(this::asVerificationCredential).forEach(credentials::add)));
        builder.singleLogoutServiceLocation(properties.getSinglelogout().getUrl());
        builder.singleLogoutServiceResponseLocation(properties.getSinglelogout().getResponseUrl());
        builder.singleLogoutServiceBinding(properties.getSinglelogout().getBinding());
        builder.entityId(properties.getEntityId());
        RelyingPartyRegistration registration = builder.build();
        boolean signRequest = registration.getAssertingPartyDetails().getWantAuthnRequestsSigned();
        this.validateSigningCredentials(properties, signRequest);
        return registration;
    }

    private Consumer<RelyingPartyRegistration.AssertingPartyDetails.Builder> mapAssertingParty(Saml2RelyingPartyProperties.AssertingParty assertingParty, boolean usingMetadata) {
        return details -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(assertingParty::getEntityId).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).entityId(arg_0));
            map.from(assertingParty.getSinglesignon()::getBinding).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).singleSignOnServiceBinding(arg_0));
            map.from(assertingParty.getSinglesignon()::getUrl).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).singleSignOnServiceLocation(arg_0));
            map.from(assertingParty.getSinglesignon()::isSignRequest).when(signRequest -> !usingMetadata).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).wantAuthnRequestsSigned(arg_0));
            map.from(assertingParty.getSinglelogout()::getUrl).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).singleLogoutServiceLocation(arg_0));
            map.from(assertingParty.getSinglelogout()::getResponseUrl).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).singleLogoutServiceResponseLocation(arg_0));
            map.from(assertingParty.getSinglelogout()::getBinding).to(arg_0 -> ((RelyingPartyRegistration.AssertingPartyDetails.Builder)details).singleLogoutServiceBinding(arg_0));
        };
    }

    private void validateSigningCredentials(Saml2RelyingPartyProperties.Registration properties, boolean signRequest) {
        if (signRequest) {
            Assert.state(!properties.getSigning().getCredentials().isEmpty(), "Signing credentials must not be empty when authentication requests require signing.");
        }
    }

    private Saml2X509Credential asSigningCredential(Saml2RelyingPartyProperties.Registration.Signing.Credential properties) {
        RSAPrivateKey privateKey = this.readPrivateKey(properties.getPrivateKeyLocation());
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential((PrivateKey)privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.SIGNING});
    }

    private Saml2X509Credential asDecryptionCredential(Saml2RelyingPartyProperties.Decryption.Credential properties) {
        RSAPrivateKey privateKey = this.readPrivateKey(properties.getPrivateKeyLocation());
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential((PrivateKey)privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.DECRYPTION});
    }

    private Saml2X509Credential asVerificationCredential(Saml2RelyingPartyProperties.AssertingParty.Verification.Credential properties) {
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential(certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION, Saml2X509Credential.Saml2X509CredentialType.VERIFICATION});
    }

    private RSAPrivateKey readPrivateKey(Resource location) {
        RSAPrivateKey rSAPrivateKey;
        block8: {
            Assert.state(location != null, "No private key location specified");
            Assert.state(location.exists(), () -> "Private key location '" + location + "' does not exist");
            InputStream inputStream = location.getInputStream();
            try {
                rSAPrivateKey = RsaKeyConverters.pkcs8().convert(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            inputStream.close();
        }
        return rSAPrivateKey;
    }

    private X509Certificate readCertificate(Resource location) {
        X509Certificate x509Certificate;
        block8: {
            Assert.state(location != null, "No certificate location specified");
            Assert.state(location.exists(), () -> "Certificate  location '" + location + "' does not exist");
            InputStream inputStream = location.getInputStream();
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            inputStream.close();
        }
        return x509Certificate;
    }
}

