/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.MissingParametersCompilerArgumentException;
import org.springframework.boot.context.properties.bind.Nested;
import org.springframework.core.KotlinDetector;
import org.springframework.core.KotlinReflectionParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class BindableRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    private final Class<?>[] types;

    protected BindableRuntimeHintsRegistrar(Class<?> ... types) {
        this.types = types;
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerHints(hints);
    }

    public void registerHints(RuntimeHints hints) {
        HashSet compiledWithoutParameters = new HashSet();
        for (Class<?> type : this.types) {
            new Processor(type, compiledWithoutParameters).process(hints.reflection());
        }
        if (!compiledWithoutParameters.isEmpty()) {
            throw new MissingParametersCompilerArgumentException(compiledWithoutParameters);
        }
    }

    public static BindableRuntimeHintsRegistrar forTypes(Iterable<Class<?>> types) {
        Assert.notNull(types, "Types must not be null");
        return BindableRuntimeHintsRegistrar.forTypes((Class[])StreamSupport.stream(types.spliterator(), false).toArray(Class[]::new));
    }

    public static BindableRuntimeHintsRegistrar forTypes(Class<?> ... types) {
        return new BindableRuntimeHintsRegistrar(types);
    }

    private final class Processor {
        private static final ParameterNameDiscoverer parameterNameDiscoverer;
        private final Class<?> type;
        private final Constructor<?> bindConstructor;
        private final PropertyDescriptor[] propertyDescriptors;
        private final Set<Class<?>> seen;
        private final Set<Class<?>> compiledWithoutParameters;

        Processor(Class<?> type, Set<Class<?>> compiledWithoutParameters) {
            this(type, false, new HashSet(), compiledWithoutParameters);
        }

        private Processor(Class<?> type, boolean nestedType, Set<Class<?>> seen, Set<Class<?>> compiledWithoutParameters) {
            this.type = type;
            this.bindConstructor = BindConstructorProvider.DEFAULT.getBindConstructor(Bindable.of(type), nestedType);
            this.propertyDescriptors = BeanUtils.getPropertyDescriptors(type);
            this.seen = seen;
            this.compiledWithoutParameters = compiledWithoutParameters;
        }

        void process(ReflectionHints hints) {
            if (this.seen.contains(this.type)) {
                return;
            }
            this.seen.add(this.type);
            this.handleConstructor(hints);
            if (this.bindConstructor != null) {
                this.handleValueObjectProperties(hints);
            } else if (!ObjectUtils.isEmpty(this.propertyDescriptors)) {
                this.handleJavaBeanProperties(hints);
            }
        }

        private void handleConstructor(ReflectionHints hints) {
            if (this.bindConstructor != null) {
                this.verifyParameterNamesAreAvailable();
                hints.registerConstructor(this.bindConstructor, ExecutableMode.INVOKE);
                return;
            }
            Arrays.stream(this.type.getDeclaredConstructors()).filter(this::hasNoParameters).findFirst().ifPresent(constructor -> hints.registerConstructor((Constructor<?>)constructor, ExecutableMode.INVOKE));
        }

        private void verifyParameterNamesAreAvailable() {
            String[] parameterNames = parameterNameDiscoverer.getParameterNames(this.bindConstructor);
            if (parameterNames == null) {
                this.compiledWithoutParameters.add(this.bindConstructor.getDeclaringClass());
            }
        }

        private boolean hasNoParameters(Constructor<?> candidate) {
            return candidate.getParameterCount() == 0;
        }

        private void handleValueObjectProperties(ReflectionHints hints) {
            for (int i2 = 0; i2 < this.bindConstructor.getParameterCount(); ++i2) {
                String propertyName = this.bindConstructor.getParameters()[i2].getName();
                ResolvableType propertyType = ResolvableType.forConstructorParameter(this.bindConstructor, i2);
                this.handleProperty(hints, propertyName, propertyType);
            }
        }

        private void handleJavaBeanProperties(ReflectionHints hints) {
            for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
                Method readMethod;
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod != null) {
                    hints.registerMethod(writeMethod, ExecutableMode.INVOKE);
                }
                if ((readMethod = propertyDescriptor.getReadMethod()) == null) continue;
                ResolvableType propertyType = ResolvableType.forMethodReturnType(readMethod, this.type);
                String propertyName = propertyDescriptor.getName();
                if (this.isSetterMandatory(propertyName, propertyType) && writeMethod == null) continue;
                this.handleProperty(hints, propertyName, propertyType);
                hints.registerMethod(readMethod, ExecutableMode.INVOKE);
            }
        }

        private boolean isSetterMandatory(String propertyName, ResolvableType propertyType) {
            Class<?> propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return true;
            }
            if (this.isContainer(propertyType)) {
                return false;
            }
            return !this.isNestedType(propertyName, propertyClass);
        }

        private void handleProperty(ReflectionHints hints, String propertyName, ResolvableType propertyType) {
            Class<?> propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return;
            }
            if (propertyClass.equals(this.type)) {
                return;
            }
            Class<?> componentType = this.getComponentClass(propertyType);
            if (componentType != null) {
                if (!this.isJavaType(componentType)) {
                    this.processNested(componentType, hints);
                }
            } else if (this.isNestedType(propertyName, propertyClass)) {
                this.processNested(propertyClass, hints);
            }
        }

        private void processNested(Class<?> type, ReflectionHints hints) {
            new Processor(type, true, this.seen, this.compiledWithoutParameters).process(hints);
        }

        private Class<?> getComponentClass(ResolvableType type) {
            ResolvableType componentType = this.getComponentType(type);
            if (componentType == null) {
                return null;
            }
            if (this.isContainer(componentType)) {
                return this.getComponentClass(componentType);
            }
            return componentType.toClass();
        }

        private ResolvableType getComponentType(ResolvableType type) {
            if (type.isArray()) {
                return type.getComponentType();
            }
            if (this.isCollection(type)) {
                return type.asCollection().getGeneric(new int[0]);
            }
            if (this.isMap(type)) {
                return type.asMap().getGeneric(1);
            }
            return null;
        }

        private boolean isContainer(ResolvableType type) {
            return type.isArray() || this.isCollection(type) || this.isMap(type);
        }

        private boolean isCollection(ResolvableType type) {
            return Collection.class.isAssignableFrom(type.toClass());
        }

        private boolean isMap(ResolvableType type) {
            return Map.class.isAssignableFrom(type.toClass());
        }

        private boolean isNestedType(String propertyName, Class<?> propertyType) {
            if (this.type.equals(propertyType.getDeclaringClass())) {
                return true;
            }
            Field field = ReflectionUtils.findField(this.type, propertyName);
            return field != null && MergedAnnotations.from(field).isPresent(Nested.class);
        }

        private boolean isJavaType(Class<?> candidate) {
            return candidate.getPackageName().startsWith("java.");
        }

        static {
            PrioritizedParameterNameDiscoverer discoverer = new PrioritizedParameterNameDiscoverer();
            if (KotlinDetector.isKotlinReflectPresent()) {
                discoverer.addDiscoverer(new KotlinReflectionParameterNameDiscoverer());
            }
            discoverer.addDiscoverer(new StandardReflectionParameterNameDiscoverer());
            parameterNameDiscoverer = discoverer;
        }
    }
}

