/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.List;
import org.springframework.aot.AotDetector;
import org.springframework.boot.test.autoconfigure.OverrideAutoConfiguration;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class OverrideAutoConfigurationContextCustomizerFactory
implements ContextCustomizerFactory {
    OverrideAutoConfigurationContextCustomizerFactory() {
    }

    @Override
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configurationAttributes) {
        if (AotDetector.useGeneratedArtifacts()) {
            return null;
        }
        OverrideAutoConfiguration overrideAutoConfiguration = TestContextAnnotationUtils.findMergedAnnotation(testClass, OverrideAutoConfiguration.class);
        boolean enabled = overrideAutoConfiguration != null ? overrideAutoConfiguration.enabled() : true;
        return !enabled ? new DisableAutoConfigurationContextCustomizer() : null;
    }

    private static class DisableAutoConfigurationContextCustomizer
    implements ContextCustomizer {
        private DisableAutoConfigurationContextCustomizer() {
        }

        @Override
        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            TestPropertyValues.of("spring.boot.enableautoconfiguration=false").applyTo(context);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

