/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.properties;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.test.autoconfigure.properties.PropertyMapping;
import org.springframework.boot.test.autoconfigure.properties.SkipPropertyMapping;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationsPropertySource
extends EnumerablePropertySource<Class<?>> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private final Map<String, Object> properties;

    public AnnotationsPropertySource(Class<?> source) {
        this("Annotations", source);
    }

    public AnnotationsPropertySource(String name, Class<?> source) {
        super(name, source);
        this.properties = this.getProperties(source);
    }

    private Map<String, Object> getProperties(Class<?> source) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.getProperties(source, properties);
        return properties;
    }

    private void getProperties(Class<?> source, Map<String, Object> properties) {
        MergedAnnotations.from(source, MergedAnnotations.SearchStrategy.SUPERCLASS).stream().filter(MergedAnnotationPredicates.unique(MergedAnnotation::getType)).forEach(annotation -> {
            Class type = annotation.getType();
            MergedAnnotation<PropertyMapping> typeMapping = MergedAnnotations.from(type).get(PropertyMapping.class, MergedAnnotation::isDirectlyPresent);
            String prefix = typeMapping.getValue("value", String.class).orElse("");
            SkipPropertyMapping defaultSkip = typeMapping.getValue("skip", SkipPropertyMapping.class).orElse(SkipPropertyMapping.YES);
            for (Method attribute : type.getDeclaredMethods()) {
                this.collectProperties(prefix, defaultSkip, (MergedAnnotation<?>)annotation, attribute, properties);
            }
        });
        if (TestContextAnnotationUtils.searchEnclosingClass(source)) {
            this.getProperties(source.getEnclosingClass(), properties);
        }
    }

    private void collectProperties(String prefix, SkipPropertyMapping skip, MergedAnnotation<?> annotation, Method attribute, Map<String, Object> properties) {
        MergedAnnotation<PropertyMapping> attributeMapping = MergedAnnotations.from(attribute).get(PropertyMapping.class);
        skip = attributeMapping.getValue("skip", SkipPropertyMapping.class).orElse(skip);
        if (skip == SkipPropertyMapping.YES) {
            return;
        }
        Optional<Object> value = annotation.getValue(attribute.getName());
        if (!value.isPresent()) {
            return;
        }
        if (skip == SkipPropertyMapping.ON_DEFAULT_VALUE && ObjectUtils.nullSafeEquals(value.get(), annotation.getDefaultValue(attribute.getName()).orElse(null))) {
            return;
        }
        String name = this.getName(prefix, attributeMapping, attribute);
        this.putProperties(name, skip, value.get(), properties);
    }

    private String getName(String prefix, MergedAnnotation<?> attributeMapping, Method attribute) {
        String name = attributeMapping.getValue("value", String.class).orElse("");
        if (!StringUtils.hasText(name)) {
            name = this.toKebabCase(attribute.getName());
        }
        return this.dotAppend(prefix, name);
    }

    private String toKebabCase(String name) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(name);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, matcher.group(1) + "-" + StringUtils.uncapitalize(matcher.group(2)));
        }
        matcher.appendTail(result);
        return result.toString().toLowerCase(Locale.ENGLISH);
    }

    private String dotAppend(String prefix, String postfix) {
        if (StringUtils.hasText(prefix)) {
            return prefix.endsWith(".") ? prefix + postfix : prefix + "." + postfix;
        }
        return postfix;
    }

    private void putProperties(String name, SkipPropertyMapping defaultSkip, Object value, Map<String, Object> properties) {
        if (ObjectUtils.isArray(value)) {
            Object[] array = ObjectUtils.toObjectArray(value);
            for (int i2 = 0; i2 < array.length; ++i2) {
                this.putProperties(name + "[" + i2 + "]", defaultSkip, array[i2], properties);
            }
        } else if (value instanceof MergedAnnotation) {
            MergedAnnotation annotation = (MergedAnnotation)value;
            for (Method attribute : annotation.getType().getDeclaredMethods()) {
                this.collectProperties(name, defaultSkip, (MergedAnnotation)value, attribute, properties);
            }
        } else {
            properties.put(name, value);
        }
    }

    @Override
    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return StringUtils.toStringArray(this.properties.keySet());
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.properties.equals(((AnnotationsPropertySource)obj).properties);
    }

    @Override
    public int hashCode() {
        return this.properties.hashCode();
    }
}

