/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.test.context.aot.TestAotProcessor;
import org.springframework.util.Assert;

public class SpringBootTestAotProcessor
extends TestAotProcessor {
    public SpringBootTestAotProcessor(Set<Path> classpathRoots, AbstractAotProcessor.Settings settings) {
        super(classpathRoots, settings);
    }

    public static void main(String[] args) {
        int requiredArgs = 6;
        Assert.isTrue(args.length >= requiredArgs, () -> "Usage: %s <classpathRoots> <sourceOutput> <resourceOutput> <classOutput> <groupId> <artifactId>".formatted(TestAotProcessor.class.getName()));
        Set<Path> classpathRoots = Arrays.stream(args[0].split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        AbstractAotProcessor.Settings settings = AbstractAotProcessor.Settings.builder().sourceOutput(Paths.get(args[1], new String[0])).resourceOutput(Paths.get(args[2], new String[0])).classOutput(Paths.get(args[3], new String[0])).groupId(args[4]).artifactId(args[5]).build();
        new SpringBootTestAotProcessor(classpathRoots, settings).process();
    }
}

