/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class GsonTester<T>
extends AbstractJsonMarshalTester<T> {
    private final Gson gson;

    protected GsonTester(Gson gson) {
        Assert.notNull((Object)gson, "Gson must not be null");
        this.gson = gson;
    }

    public GsonTester(Class<?> resourceLoadClass, ResolvableType type, Gson gson) {
        super(resourceLoadClass, type);
        Assert.notNull((Object)gson, "Gson must not be null");
        this.gson = gson;
    }

    @Override
    protected String writeObject(T value, ResolvableType type) throws IOException {
        return this.gson.toJson(value, type.getType());
    }

    @Override
    protected T readObject(Reader reader, ResolvableType type) throws IOException {
        return (T)this.gson.fromJson(reader, type.getType());
    }

    public static void initFields(Object testInstance, Gson gson) {
        new GsonFieldInitializer().initFields(testInstance, gson);
    }

    public static void initFields(Object testInstance, ObjectFactory<Gson> gson) {
        new GsonFieldInitializer().initFields(testInstance, gson);
    }

    private static class GsonFieldInitializer
    extends AbstractJsonMarshalTester.FieldInitializer<Gson> {
        protected GsonFieldInitializer() {
            super(GsonTester.class);
        }

        @Override
        protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type, Gson marshaller) {
            return new GsonTester<Object>(resourceLoadClass, type, marshaller);
        }
    }
}

