/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.boot.test.json.JsonLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonContentAssert
extends AbstractAssert<JsonContentAssert, CharSequence> {
    private final JsonLoader loader;
    private final Configuration configuration;

    public JsonContentAssert(Class<?> resourceLoadClass, CharSequence json) {
        this(resourceLoadClass, null, json);
    }

    public JsonContentAssert(Class<?> resourceLoadClass, Charset charset, CharSequence json) {
        this(resourceLoadClass, charset, json, Configuration.defaultConfiguration());
    }

    JsonContentAssert(Class<?> resourceLoadClass, Charset charset, CharSequence json, Configuration configuration) {
        super(json, JsonContentAssert.class);
        this.configuration = configuration;
        this.loader = new JsonLoader(resourceLoadClass, charset);
    }

    @Override
    public JsonContentAssert isEqualTo(Object expected) {
        if (expected == null || expected instanceof CharSequence) {
            return this.isEqualToJson((CharSequence)expected);
        }
        if (expected instanceof byte[]) {
            byte[] bytes = (byte[])expected;
            return this.isEqualToJson(bytes);
        }
        if (expected instanceof File) {
            File file = (File)expected;
            return this.isEqualToJson(file);
        }
        if (expected instanceof InputStream) {
            InputStream inputStream = (InputStream)expected;
            return this.isEqualToJson(inputStream);
        }
        if (expected instanceof Resource) {
            Resource resource = (Resource)expected;
            return this.isEqualToJson(resource);
        }
        this.failWithMessage("Unsupported type for JSON assert %s", expected.getClass());
        return null;
    }

    public JsonContentAssert isEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isStrictlyEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(byte[] expected) {
        return this.assertNotFailed(this.compare((CharSequence)this.loader.getJson(expected), JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isEqualToJson(CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(byte[] expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(File expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(InputStream expected, JSONCompareMode compareMode) {
        return this.assertNotFailed(this.compare((CharSequence)this.loader.getJson(expected), compareMode));
    }

    public JsonContentAssert isEqualToJson(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(byte[] expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(File expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(InputStream expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(Resource expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    @Override
    public JsonContentAssert isNotEqualTo(Object expected) {
        if (expected == null || expected instanceof CharSequence) {
            return this.isNotEqualToJson((CharSequence)expected);
        }
        if (expected instanceof byte[]) {
            byte[] bytes = (byte[])expected;
            return this.isNotEqualToJson(bytes);
        }
        if (expected instanceof File) {
            File file = (File)expected;
            return this.isNotEqualToJson(file);
        }
        if (expected instanceof InputStream) {
            InputStream inputStream = (InputStream)expected;
            return this.isNotEqualToJson(inputStream);
        }
        if (expected instanceof Resource) {
            Resource resource = (Resource)expected;
            return this.isNotEqualToJson(resource);
        }
        this.failWithMessage("Unsupported type for JSON assert %s", expected.getClass());
        return null;
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected) {
        return this.assertNotPassed(this.compare((CharSequence)this.loader.getJson(expected), JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(File expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(File expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert hasJsonPath(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasPath();
        return this;
    }

    public JsonContentAssert hasJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Object.class, "an object");
        return this;
    }

    public JsonContentAssert hasJsonPathStringValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(String.class, "a string");
        return this;
    }

    public JsonContentAssert hasJsonPathNumberValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Number.class, "a number");
        return this;
    }

    public JsonContentAssert hasJsonPathBooleanValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Boolean.class, "a boolean");
        return this;
    }

    public JsonContentAssert hasJsonPathArrayValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(List.class, "an array");
        return this;
    }

    public JsonContentAssert hasJsonPathMapValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Map.class, "a map");
        return this;
    }

    public JsonContentAssert hasEmptyJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasEmptyValue();
        return this;
    }

    public JsonContentAssert doesNotHaveJsonPath(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertDoesNotHavePath();
        return this;
    }

    public JsonContentAssert doesNotHaveJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertDoesNotHaveValue();
        return this;
    }

    public JsonContentAssert doesNotHaveEmptyJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertDoesNotHaveEmptyValue();
        return this;
    }

    public AbstractObjectAssert<?, Object> extractingJsonPathValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(new JsonPathValue(expression, args).getValue(false));
    }

    public AbstractCharSequenceAssert<?, String> extractingJsonPathStringValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(this.extractingJsonPathValue(expression, args, String.class, "a string"));
    }

    public AbstractObjectAssert<?, Number> extractingJsonPathNumberValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(this.extractingJsonPathValue(expression, args, Number.class, "a number"));
    }

    public AbstractBooleanAssert<?> extractingJsonPathBooleanValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(this.extractingJsonPathValue(expression, args, Boolean.class, "a boolean"));
    }

    public <E> ListAssert<E> extractingJsonPathArrayValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(this.extractingJsonPathValue(expression, args, List.class, "an array"));
    }

    public <K, V> MapAssert<K, V> extractingJsonPathMapValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat(this.extractingJsonPathValue(expression, args, Map.class, "a map"));
    }

    private <T> T extractingJsonPathValue(CharSequence expression, Object[] args, Class<T> type, String expectedDescription) {
        JsonPathValue value = new JsonPathValue(expression, args);
        if (value.getValue(false) != null) {
            value.assertHasValue(type, expectedDescription);
        }
        return (T)value.getValue(false);
    }

    private JSONCompareResult compare(CharSequence expectedJson, JSONCompareMode compareMode) {
        if (this.actual == null) {
            return this.compareForNull(expectedJson);
        }
        try {
            return JSONCompare.compareJSON(expectedJson != null ? expectedJson.toString() : null, ((CharSequence)this.actual).toString(), compareMode);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            throw new IllegalStateException(ex);
        }
    }

    private JSONCompareResult compare(CharSequence expectedJson, JSONComparator comparator) {
        if (this.actual == null) {
            return this.compareForNull(expectedJson);
        }
        try {
            return JSONCompare.compareJSON(expectedJson != null ? expectedJson.toString() : null, ((CharSequence)this.actual).toString(), comparator);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            throw new IllegalStateException(ex);
        }
    }

    private JSONCompareResult compareForNull(CharSequence expectedJson) {
        JSONCompareResult result = new JSONCompareResult();
        result.passed();
        if (expectedJson != null) {
            result.fail("Expected null JSON");
        }
        return result;
    }

    private JsonContentAssert assertNotFailed(JSONCompareResult result) {
        if (result.failed()) {
            this.failWithMessage("JSON Comparison failure: %s", result.getMessage());
        }
        return this;
    }

    private JsonContentAssert assertNotPassed(JSONCompareResult result) {
        if (result.passed()) {
            this.failWithMessage("JSON Comparison failure: %s", result.getMessage());
        }
        return this;
    }

    private class JsonPathValue {
        private final String expression;
        private final JsonPath jsonPath;

        JsonPathValue(CharSequence expression, Object ... args) {
            Assert.hasText(expression != null ? expression.toString() : null, "expression must not be null or empty");
            this.expression = String.format(expression.toString(), args);
            this.jsonPath = JsonPath.compile(this.expression, new Predicate[0]);
        }

        void assertHasEmptyValue() {
            if (ObjectUtils.isEmpty(this.getValue(false)) || this.isIndefiniteAndEmpty()) {
                return;
            }
            JsonContentAssert.this.failWithMessage(this.getExpectedValueMessage("an empty value"), new Object[0]);
        }

        void assertDoesNotHaveEmptyValue() {
            if (!ObjectUtils.isEmpty(this.getValue(false))) {
                return;
            }
            JsonContentAssert.this.failWithMessage(this.getExpectedValueMessage("a non-empty value"), new Object[0]);
        }

        void assertHasPath() {
            try {
                this.read();
            }
            catch (PathNotFoundException ex) {
                JsonContentAssert.this.failWithMessage("No JSON path \"%s\" found", new Object[]{this.expression});
            }
        }

        void assertDoesNotHavePath() {
            try {
                this.read();
                JsonContentAssert.this.failWithMessage("Expecting no JSON path \"%s\"", new Object[]{this.expression});
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }

        void assertHasValue(Class<?> type, String expectedDescription) {
            Object value = this.getValue(true);
            if (value == null || this.isIndefiniteAndEmpty()) {
                this.failWithNoValueMessage();
            }
            if (type != null && !type.isInstance(value)) {
                JsonContentAssert.this.failWithMessage(this.getExpectedValueMessage(expectedDescription), new Object[0]);
            }
        }

        void assertDoesNotHaveValue() {
            if (this.getValue(false) == null || this.isIndefiniteAndEmpty()) {
                return;
            }
            JsonContentAssert.this.failWithMessage(this.getExpectedValueMessage("no value"), new Object[0]);
        }

        private boolean isIndefiniteAndEmpty() {
            return !this.isDefinite() && this.isEmpty();
        }

        private boolean isDefinite() {
            return this.jsonPath.isDefinite();
        }

        private boolean isEmpty() {
            return ObjectUtils.isEmpty(this.getValue(false));
        }

        Object getValue(boolean required) {
            try {
                return this.read();
            }
            catch (Exception ex) {
                if (required) {
                    this.failWithNoValueMessage();
                }
                return null;
            }
        }

        private void failWithNoValueMessage() {
            JsonContentAssert.this.failWithMessage("No value at JSON path \"%s\"", new Object[]{this.expression});
        }

        private Object read() {
            CharSequence json = (CharSequence)JsonContentAssert.this.actual;
            return this.jsonPath.read(json != null ? json.toString() : null, JsonContentAssert.this.configuration);
        }

        private String getExpectedValueMessage(String expectedDescription) {
            return String.format("Expected %s at JSON path \"%s\" but found: %s", expectedDescription, this.expression, ObjectUtils.nullSafeToString(StringUtils.quoteIfString(this.getValue(false))));
        }
    }
}

