/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.SpelCriteria;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class SpelCriteriaAccessor
implements CriteriaAccessor<SpelCriteria> {
    private final SpelExpressionParser parser;

    public SpelCriteriaAccessor(SpelExpressionParser parser) {
        Assert.notNull((Object)parser, "SpelExpressionParser must not be null");
        this.parser = parser;
    }

    @Override
    public SpelCriteria resolve(KeyValueQuery<?> query2) {
        if (query2.getCriteria() == null) {
            return null;
        }
        if (query2.getCriteria() instanceof SpelExpression) {
            return new SpelCriteria((SpelExpression)query2.getCriteria());
        }
        if (query2.getCriteria() instanceof String) {
            return new SpelCriteria(this.parser.parseRaw((String)query2.getCriteria()));
        }
        if (query2.getCriteria() instanceof SpelCriteria) {
            return (SpelCriteria)query2.getCriteria();
        }
        throw new IllegalArgumentException("Cannot create SpelCriteria for " + query2.getCriteria());
    }
}

