/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.NamedNode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisNode
implements NamedNode {
    @Nullable
    String id;
    @Nullable
    String name;
    @Nullable
    String host;
    int port;
    @Nullable
    NodeType type;
    @Nullable
    String masterId;

    public RedisNode(String host, int port) {
        Assert.notNull((Object)host, "host must not be null");
        this.host = host;
        this.port = port;
    }

    protected RedisNode() {
    }

    private RedisNode(RedisNode redisNode) {
        this.id = redisNode.id;
        this.name = redisNode.name;
        this.host = redisNode.host;
        this.port = redisNode.port;
        this.type = redisNode.type;
        this.masterId = redisNode.masterId;
    }

    public static RedisNode fromString(String hostPortString) {
        String host;
        Assert.notNull((Object)hostPortString, "HostAndPort must not be null");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = RedisNode.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = -1;
        try {
            port = Integer.parseInt(portString);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Unparseable port number: %s", hostPortString));
        }
        if (!RedisNode.isValidPort(port)) {
            throw new IllegalArgumentException(String.format("Port number out of range: %s", hostPortString));
        }
        return new RedisNode(host, port);
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        if (hostPortString.charAt(0) != '[') {
            throw new IllegalArgumentException(String.format("Bracketed host-port string must start with a bracket: %s", hostPortString));
        }
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        if (colonIndex <= -1 || closeBracketIndex <= colonIndex) {
            throw new IllegalArgumentException(String.format("Invalid bracketed host/port: %s", hostPortString));
        }
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        if (hostPortString.charAt(closeBracketIndex + 1) != ':') {
            throw new IllegalArgumentException(String.format("Only a colon may follow a close bracket: %s", hostPortString));
        }
        for (int i2 = closeBracketIndex + 2; i2 < hostPortString.length(); ++i2) {
            if (Character.isDigit(hostPortString.charAt(i2))) continue;
            throw new IllegalArgumentException(String.format("Port must be numeric: %s", hostPortString));
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public boolean hasValidHost() {
        return StringUtils.hasText(this.host);
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public String asString() {
        if (this.host != null && this.host.contains(":")) {
            return "[" + this.host + "]:" + this.port;
        }
        return this.host + ":" + this.port;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getMasterId() {
        return this.masterId;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    public NodeType getType() {
        return this.type;
    }

    public boolean isMaster() {
        return ObjectUtils.nullSafeEquals((Object)NodeType.MASTER, (Object)this.getType());
    }

    public boolean isReplica() {
        return ObjectUtils.nullSafeEquals((Object)NodeType.REPLICA, (Object)this.getType());
    }

    public static RedisNodeBuilder newRedisNode() {
        return new RedisNodeBuilder();
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.host);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.port);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RedisNode)) {
            return false;
        }
        RedisNode other = (RedisNode)obj;
        if (!ObjectUtils.nullSafeEquals(this.host, other.host)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.port, other.port)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.name, other.name);
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static enum NodeType {
        MASTER,
        REPLICA;

    }

    public static class RedisNodeBuilder {
        private RedisNode node = new RedisNode();

        public RedisNodeBuilder withName(String name) {
            this.node.name = name;
            return this;
        }

        public RedisNodeBuilder listeningAt(String host, int port) {
            Assert.notNull((Object)host, "Hostname must not be null");
            this.node.host = host;
            this.node.port = port;
            return this;
        }

        public RedisNodeBuilder withId(String id) {
            this.node.id = id;
            return this;
        }

        public RedisNodeBuilder promotedAs(NodeType type) {
            this.node.type = type;
            return this;
        }

        public RedisNodeBuilder replicaOf(String masterId) {
            this.node.masterId = masterId;
            return this;
        }

        public RedisNode build() {
            return new RedisNode(this.node);
        }
    }
}

