/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface RedisZSetCommands {
    @Nullable
    default public Boolean zAdd(byte[] key, double score, byte[] value) {
        return this.zAdd(key, score, value, ZAddArgs.NONE);
    }

    @Nullable
    public Boolean zAdd(byte[] var1, double var2, byte[] var4, ZAddArgs var5);

    @Nullable
    default public Long zAdd(byte[] key, Set<Tuple> tuples) {
        return this.zAdd(key, tuples, ZAddArgs.NONE);
    }

    public Long zAdd(byte[] var1, Set<Tuple> var2, ZAddArgs var3);

    @Nullable
    public Long zRem(byte[] var1, byte[] ... var2);

    @Nullable
    public Double zIncrBy(byte[] var1, double var2, byte[] var4);

    @Nullable
    public byte[] zRandMember(byte[] var1);

    @Nullable
    public List<byte[]> zRandMember(byte[] var1, long var2);

    @Nullable
    public Tuple zRandMemberWithScore(byte[] var1);

    @Nullable
    public List<Tuple> zRandMemberWithScore(byte[] var1, long var2);

    @Nullable
    public Long zRank(byte[] var1, byte[] var2);

    @Nullable
    public Long zRevRank(byte[] var1, byte[] var2);

    @Nullable
    public Set<byte[]> zRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.zRangeByScore(key, org.springframework.data.domain.Range.closed(min, max));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, org.springframework.data.domain.Range.closed(min, max));
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, org.springframework.data.domain.Range.closed(min, max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, org.springframework.data.domain.Range.closed(min, max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    public Set<byte[]> zRevRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRevRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, org.springframework.data.domain.Range.closed(min, max));
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRevRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, org.springframework.data.domain.Range.closed(min, max), Limit.unlimited());
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, org.springframework.data.domain.Range.closed(min, max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<byte[]> zRevRangeByScore(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, org.springframework.data.domain.Range.closed(min, max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRevRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    default public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, org.springframework.data.domain.Range.closed(min, max));
    }

    @Nullable
    public Long zCount(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2);

    @Nullable
    public Long zLexCount(byte[] var1, org.springframework.data.domain.Range<byte[]> var2);

    @Nullable
    public Tuple zPopMin(byte[] var1);

    @Nullable
    public Set<Tuple> zPopMin(byte[] var1, long var2);

    @Nullable
    public Tuple bZPopMin(byte[] var1, long var2, TimeUnit var4);

    @Nullable
    public Tuple zPopMax(byte[] var1);

    @Nullable
    public Set<Tuple> zPopMax(byte[] var1, long var2);

    @Nullable
    public Tuple bZPopMax(byte[] var1, long var2, TimeUnit var4);

    @Nullable
    public Long zCard(byte[] var1);

    @Nullable
    public Double zScore(byte[] var1, byte[] var2);

    @Nullable
    public List<Double> zMScore(byte[] var1, byte[] ... var2);

    @Nullable
    public Long zRemRange(byte[] var1, long var2, long var4);

    public Long zRemRangeByLex(byte[] var1, org.springframework.data.domain.Range<byte[]> var2);

    @Nullable
    default public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, org.springframework.data.domain.Range.closed(min, max));
    }

    @Nullable
    public Long zRemRangeByScore(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2);

    @Nullable
    public Set<byte[]> zDiff(byte[] ... var1);

    @Nullable
    public Set<Tuple> zDiffWithScores(byte[] ... var1);

    @Nullable
    public Long zDiffStore(byte[] var1, byte[] ... var2);

    @Nullable
    public Set<byte[]> zInter(byte[] ... var1);

    @Nullable
    public Set<Tuple> zInterWithScores(byte[] ... var1);

    @Nullable
    default public Set<Tuple> zInterWithScores(Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zInterWithScores(aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Set<Tuple> zInterWithScores(Aggregate var1, Weights var2, byte[] ... var3);

    @Nullable
    public Long zInterStore(byte[] var1, byte[] ... var2);

    @Nullable
    default public Long zInterStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zInterStore(destKey, aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Long zInterStore(byte[] var1, Aggregate var2, Weights var3, byte[] ... var4);

    @Nullable
    public Set<byte[]> zUnion(byte[] ... var1);

    @Nullable
    public Set<Tuple> zUnionWithScores(byte[] ... var1);

    @Nullable
    default public Set<Tuple> zUnionWithScores(Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zUnionWithScores(aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Set<Tuple> zUnionWithScores(Aggregate var1, Weights var2, byte[] ... var3);

    @Nullable
    public Long zUnionStore(byte[] var1, byte[] ... var2);

    @Nullable
    default public Long zUnionStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zUnionStore(destKey, aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Long zUnionStore(byte[] var1, Aggregate var2, Weights var3, byte[] ... var4);

    public Cursor<Tuple> zScan(byte[] var1, ScanOptions var2);

    @Nullable
    @Deprecated
    default public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max).toRange());
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, String var2, String var3, long var4, long var6);

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, org.springframework.data.domain.Range<? extends Number> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key) {
        return this.zRangeByLex(key, org.springframework.data.domain.Range.unbounded());
    }

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key, org.springframework.data.domain.Range<byte[]> range) {
        return this.zRangeByLex(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByLex(byte[] var1, org.springframework.data.domain.Range<byte[]> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    default public Set<byte[]> zRevRangeByLex(byte[] key) {
        return this.zRevRangeByLex(key, org.springframework.data.domain.Range.unbounded());
    }

    @Nullable
    default public Set<byte[]> zRevRangeByLex(byte[] key, org.springframework.data.domain.Range<byte[]> range) {
        return this.zRevRangeByLex(key, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRevRangeByLex(byte[] var1, org.springframework.data.domain.Range<byte[]> var2, org.springframework.data.redis.connection.Limit var3);

    @Nullable
    default public Long zRangeStoreByLex(byte[] dstKey, byte[] srcKey, org.springframework.data.domain.Range<byte[]> range) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreByLex(byte[] var1, byte[] var2, org.springframework.data.domain.Range<byte[]> var3, org.springframework.data.redis.connection.Limit var4);

    @Nullable
    default public Long zRangeStoreRevByLex(byte[] dstKey, byte[] srcKey, org.springframework.data.domain.Range<byte[]> range) {
        return this.zRangeStoreRevByLex(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreRevByLex(byte[] var1, byte[] var2, org.springframework.data.domain.Range<byte[]> var3, org.springframework.data.redis.connection.Limit var4);

    @Nullable
    default public Long zRangeStoreByScore(byte[] dstKey, byte[] srcKey, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreByScore(byte[] var1, byte[] var2, org.springframework.data.domain.Range<? extends Number> var3, org.springframework.data.redis.connection.Limit var4);

    @Nullable
    default public Long zRangeStoreRevByScore(byte[] dstKey, byte[] srcKey, org.springframework.data.domain.Range<? extends Number> range) {
        return this.zRangeStoreRevByScore(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreRevByScore(byte[] var1, byte[] var2, org.springframework.data.domain.Range<? extends Number> var3, org.springframework.data.redis.connection.Limit var4);

    public static class ZAddArgs {
        private static final ZAddArgs NONE = new ZAddArgs(EnumSet.noneOf(Flag.class));
        private final Set<Flag> flags;

        private ZAddArgs(Set<Flag> flags) {
            this.flags = flags;
        }

        public static ZAddArgs empty() {
            return new ZAddArgs(EnumSet.noneOf(Flag.class));
        }

        public static ZAddArgs ifNotExists() {
            return ZAddArgs.empty().nx();
        }

        public static ZAddArgs ifExists() {
            return ZAddArgs.empty().xx();
        }

        public ZAddArgs nx() {
            this.flags.add(Flag.NX);
            return this;
        }

        public ZAddArgs xx() {
            this.flags.add(Flag.XX);
            return this;
        }

        public ZAddArgs lt() {
            this.flags.add(Flag.LT);
            return this;
        }

        public ZAddArgs gt() {
            this.flags.add(Flag.GT);
            return this;
        }

        public ZAddArgs ch() {
            this.flags.add(Flag.CH);
            return this;
        }

        public boolean contains(Flag flag) {
            return this.flags.contains((Object)flag);
        }

        public boolean isEmpty() {
            return !this.flags.isEmpty();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZAddArgs zAddArgs = (ZAddArgs)o;
            return ObjectUtils.nullSafeEquals(this.flags, zAddArgs.flags);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.flags);
        }

        public static enum Flag {
            XX,
            NX,
            GT,
            LT,
            CH;

        }
    }

    @Deprecated
    public static class Limit
    extends org.springframework.data.redis.connection.Limit {
    }

    @Deprecated
    public static class Range {
        @Nullable
        Boundary min;
        @Nullable
        Boundary max;

        public static Range range() {
            return new Range();
        }

        public static Range unbounded() {
            Range range = new Range();
            range.min = Boundary.infinite();
            range.max = Boundary.infinite();
            return range;
        }

        public Range gte(Object min) {
            Assert.notNull(min, "Min already set for range.");
            this.min = new Boundary(min, true);
            return this;
        }

        public Range gt(Object min) {
            Assert.notNull(min, "Min already set for range.");
            this.min = new Boundary(min, false);
            return this;
        }

        public Range lte(Object max) {
            Assert.notNull(max, "Max already set for range.");
            this.max = new Boundary(max, true);
            return this;
        }

        public Range lt(Object max) {
            Assert.notNull(max, "Max already set for range.");
            this.max = new Boundary(max, false);
            return this;
        }

        @Nullable
        public Boundary getMin() {
            return this.min;
        }

        @Nullable
        public Boundary getMax() {
            return this.max;
        }

        public <T> org.springframework.data.domain.Range<T> toRange() {
            Range.Bound<Object> lower = this.toBound(this.min);
            Range.Bound<Object> upper = this.toBound(this.max);
            return org.springframework.data.domain.Range.from(lower).to(upper);
        }

        private Range.Bound<Object> toBound(@Nullable Boundary boundary) {
            if (boundary == null || boundary.value == null) {
                return Range.Bound.unbounded();
            }
            return boundary.isIncluding() ? Range.Bound.inclusive(boundary.getValue()) : Range.Bound.exclusive(boundary.getValue());
        }

        public static class Boundary {
            @Nullable
            Object value;
            boolean including;

            static Boundary infinite() {
                return new Boundary(null, true);
            }

            Boundary(@Nullable Object value, boolean including) {
                this.value = value;
                this.including = including;
            }

            @Nullable
            public Object getValue() {
                return this.value;
            }

            public boolean isIncluding() {
                return this.including;
            }
        }
    }
}

