/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.util.Assert;

class DefaultSetOperations<K, V>
extends AbstractOperations<K, V>
implements SetOperations<K, V> {
    DefaultSetOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Long add(K key, V ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.sAdd(rawKey, rawValues));
    }

    @Override
    public Set<V> difference(K key, K otherKey) {
        return this.difference(Arrays.asList(key, otherKey));
    }

    @Override
    public Set<V> difference(K key, Collection<K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.sDiff(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> difference(Collection<K> keys) {
        byte[][] rawKeys = this.rawKeys(keys);
        Set rawValues = this.execute(connection -> connection.sDiff(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long differenceAndStore(K key, K otherKey, K destKey) {
        return this.differenceAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sDiffStore(rawDestKey, rawKeys));
    }

    @Override
    public Long differenceAndStore(Collection<K> keys, K destKey) {
        byte[][] rawKeys = this.rawKeys(keys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sDiffStore(rawDestKey, rawKeys));
    }

    @Override
    public Set<V> intersect(K key, K otherKey) {
        return this.intersect(Arrays.asList(key, otherKey));
    }

    @Override
    public Set<V> intersect(K key, Collection<K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.sInter(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> intersect(Collection<K> keys) {
        byte[][] rawKeys = this.rawKeys(keys);
        Set rawValues = this.execute(connection -> connection.sInter(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sInterStore(rawDestKey, rawKeys));
    }

    @Override
    public Long intersectAndStore(Collection<K> keys, K destKey) {
        byte[][] rawKeys = this.rawKeys(keys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sInterStore(rawDestKey, rawKeys));
    }

    @Override
    public Boolean isMember(K key, Object o) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(o);
        return this.execute(connection -> connection.sIsMember(rawKey, rawValue));
    }

    @Override
    public Map<Object, Boolean> isMember(K key, Object ... objects) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(objects);
        return this.execute(connection -> {
            List<Boolean> result = connection.sMIsMember(rawKey, rawValues);
            if (result == null || result.size() != objects.length) {
                return null;
            }
            LinkedHashMap<Object, Boolean> isMember = new LinkedHashMap<Object, Boolean>(result.size());
            for (int i2 = 0; i2 < objects.length; ++i2) {
                isMember.put(objects[i2], result.get(i2));
            }
            return isMember;
        });
    }

    @Override
    public Set<V> members(K key) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.sMembers(rawKey));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Boolean move(K key, V value, K destKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawDestKey = this.rawKey(destKey);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.sMove(rawKey, rawDestKey, rawValue));
    }

    @Override
    public V randomMember(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.sRandMember(rawKey);
            }
        });
    }

    @Override
    public Set<V> distinctRandomMembers(K key, long count) {
        Assert.isTrue(count >= 0L, "Negative count not supported; Use randomMembers to allow duplicate elements");
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> new HashSet<byte[]>(connection.sRandMember(rawKey, count)));
        return this.deserializeValues(rawValues);
    }

    @Override
    public List<V> randomMembers(K key, long count) {
        Assert.isTrue(count >= 0L, "Use a positive number for count; This method is already allowing duplicate elements");
        byte[] rawKey = this.rawKey(key);
        List rawValues = this.execute(connection -> connection.sRandMember(rawKey, -count));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long remove(K key, Object ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.sRem(rawKey, rawValues));
    }

    @Override
    public V pop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.sPop(rawKey);
            }
        });
    }

    @Override
    public List<V> pop(K key, long count) {
        byte[] rawKey = this.rawKey(key);
        List rawValues = this.execute(connection -> connection.sPop(rawKey, count));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long size(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.sCard(rawKey));
    }

    @Override
    public Set<V> union(K key, K otherKey) {
        return this.union(Arrays.asList(key, otherKey));
    }

    @Override
    public Set<V> union(K key, Collection<K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.sUnion(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> union(Collection<K> keys) {
        byte[][] rawKeys = this.rawKeys(keys);
        Set rawValues = this.execute(connection -> connection.sUnion(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sUnionStore(rawDestKey, rawKeys));
    }

    @Override
    public Long unionAndStore(Collection<K> keys, K destKey) {
        byte[][] rawKeys = this.rawKeys(keys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.sUnionStore(rawDestKey, rawKeys));
    }

    @Override
    public Cursor<V> scan(K key, ScanOptions options2) {
        byte[] rawKey = this.rawKey(key);
        return this.template.executeWithStickyConnection(connection -> new ConvertingCursor<byte[], Object>(connection.sScan(rawKey, options2), this::deserializeValue));
    }
}

