/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.DefaultSortParameters;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;

public abstract class QueryUtils {
    public static <K> SortParameters convertQuery(SortQuery<K> query2, RedisSerializer<String> stringSerializer) {
        return new DefaultSortParameters(stringSerializer.serialize(query2.getBy()), query2.getLimit(), QueryUtils.serialize(query2.getGetPattern(), stringSerializer), query2.getOrder(), query2.isAlphabetic());
    }

    private static byte[][] serialize(List<String> strings, RedisSerializer<String> stringSerializer) {
        List raw = null;
        if (strings == null) {
            raw = Collections.emptyList();
        } else {
            raw = new ArrayList(strings.size());
            for (String key : strings) {
                raw.add(stringSerializer.serialize(key));
            }
        }
        return (byte[][])raw.toArray((T[])new byte[raw.size()][]);
    }
}

