/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.QueryAnnotation;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class RepositoryInformationSupport
implements RepositoryInformation {
    private final Supplier<RepositoryMetadata> metadata;
    private final Supplier<Class<?>> repositoryBaseClass;

    public RepositoryInformationSupport(Supplier<RepositoryMetadata> metadata, Supplier<Class<?>> repositoryBaseClass) {
        Assert.notNull(metadata, "Repository metadata must not be null");
        Assert.notNull(repositoryBaseClass, "Repository base class must not be null");
        this.metadata = Lazy.of(metadata);
        this.repositoryBaseClass = Lazy.of(repositoryBaseClass);
    }

    @Override
    public Streamable<Method> getQueryMethods() {
        HashSet<Method> result = new HashSet<Method>();
        for (Method method : this.getRepositoryInterface().getMethods()) {
            if (!this.isQueryMethodCandidate(method = ClassUtils.getMostSpecificMethod(method, this.getRepositoryInterface()))) continue;
            result.add(method);
        }
        return Streamable.of(Collections.unmodifiableSet(result));
    }

    private RepositoryMetadata getMetadata() {
        return this.metadata.get();
    }

    @Override
    public Class<?> getIdType() {
        return this.getMetadata().getIdType();
    }

    @Override
    public Class<?> getDomainType() {
        return this.getMetadata().getDomainType();
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.getMetadata().getRepositoryInterface();
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return this.getMetadata().getReturnType(method);
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        return this.getMetadata().getReturnedDomainClass(method);
    }

    @Override
    public CrudMethods getCrudMethods() {
        return this.getMetadata().getCrudMethods();
    }

    @Override
    public boolean isPagingRepository() {
        return this.getMetadata().isPagingRepository();
    }

    @Override
    public Set<Class<?>> getAlternativeDomainTypes() {
        return this.getMetadata().getAlternativeDomainTypes();
    }

    @Override
    public boolean isReactiveRepository() {
        return this.getMetadata().isReactiveRepository();
    }

    @Override
    public Class<?> getRepositoryBaseClass() {
        return this.repositoryBaseClass.get();
    }

    @Override
    public boolean isQueryMethod(Method method) {
        return this.getQueryMethods().stream().anyMatch(it -> it.equals(method));
    }

    @Override
    public TypeInformation<?> getDomainTypeInformation() {
        return this.getMetadata().getDomainTypeInformation();
    }

    @Override
    public TypeInformation<?> getIdTypeInformation() {
        return this.getMetadata().getIdTypeInformation();
    }

    @Override
    public boolean hasCustomMethod() {
        Class<?> repositoryInterface = this.getRepositoryInterface();
        if (org.springframework.data.repository.util.ClassUtils.isGenericRepositoryInterface(repositoryInterface)) {
            return false;
        }
        for (Method method : repositoryInterface.getMethods()) {
            if (!this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            return true;
        }
        return false;
    }

    protected boolean isQueryAnnotationPresentOn(Method method) {
        return AnnotationUtils.findAnnotation(method, QueryAnnotation.class) != null;
    }

    protected boolean isQueryMethodCandidate(Method method) {
        return !method.isBridge() && !method.isDefault() && !Modifier.isStatic(method.getModifiers()) && (this.isQueryAnnotationPresentOn(method) || !this.isCustomMethod(method) && !this.isBaseClassMethod(method));
    }
}

