/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.CustomCollections;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.NullableWrapperConverters;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class TypeDiscoverer<S>
implements TypeInformation<S> {
    private static final ConcurrentLruCache<ResolvableType, TypeInformation<?>> CACHE = new ConcurrentLruCache<ResolvableType, TypeInformation>(64, TypeDiscoverer::new);
    private final ResolvableType resolvableType;
    private final Map<String, Optional<TypeInformation<?>>> fields = new ConcurrentHashMap();
    private final Lazy<TypeInformation<?>> componentType;
    private final Lazy<TypeInformation<?>> valueType;
    private final Map<Constructor<?>, List<TypeInformation<?>>> constructorParameters = new ConcurrentHashMap();
    private final Lazy<List<TypeInformation<?>>> typeArguments;

    protected TypeDiscoverer(ResolvableType type) {
        Assert.notNull((Object)type, "Type must not be null");
        this.resolvableType = type;
        this.componentType = Lazy.of(this::doGetComponentType);
        this.valueType = Lazy.of(this::doGetMapValueType);
        this.typeArguments = Lazy.of(this::doGetTypeArguments);
    }

    static TypeDiscoverer<?> td(ResolvableType type) {
        Assert.notNull((Object)type, "Type must not be null");
        return (TypeDiscoverer)CACHE.get(type);
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        Assert.notNull(constructor, "Constructor must not be null");
        return this.constructorParameters.computeIfAbsent(constructor, it -> {
            ArrayList target = new ArrayList();
            for (int i2 = 0; i2 < it.getParameterCount(); ++i2) {
                target.add(TypeInformation.of(ResolvableType.forConstructorParameter(it, i2)));
            }
            return target;
        });
    }

    @Override
    @Nullable
    public TypeInformation<?> getProperty(String name) {
        int separatorIndex = name.indexOf(46);
        if (separatorIndex == -1) {
            return this.fields.computeIfAbsent(name, this::getPropertyInformation).orElse(null);
        }
        String head2 = name.substring(0, separatorIndex);
        TypeInformation<?> info2 = this.getProperty(head2);
        if (info2 == null) {
            return null;
        }
        return info2.getProperty(name.substring(separatorIndex + 1));
    }

    @Override
    public boolean isCollectionLike() {
        Class<S> type = this.getType();
        return type.isArray() || Iterable.class.equals(type) || Collection.class.isAssignableFrom(type) || Streamable.class.isAssignableFrom(type) || CustomCollections.isCollection(type);
    }

    @Override
    @Nullable
    public TypeInformation<?> getComponentType() {
        return this.componentType.orElse(null);
    }

    @Nullable
    protected TypeInformation<?> doGetComponentType() {
        if (this.resolvableType.isArray()) {
            return TypeInformation.of(this.resolvableType.getComponentType());
        }
        Class<S> rawType = this.getType();
        if (this.isMap()) {
            return this.getTypeArgument(CustomCollections.getMapBaseType(rawType), 0);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        if (arguments.size() > 0) {
            return arguments.get(0);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.getTypeArgument(Iterable.class, 0);
        }
        if (this.isNullableWrapper()) {
            return this.getTypeArgument(rawType, 0);
        }
        return null;
    }

    @Override
    public boolean isMap() {
        return CustomCollections.isMap(this.getType());
    }

    @Override
    @Nullable
    public TypeInformation<?> getMapValueType() {
        return this.valueType.orElse(null);
    }

    @Nullable
    protected TypeInformation<?> doGetMapValueType() {
        return this.isMap() ? this.getTypeArgument(CustomCollections.getMapBaseType(this.getType()), 1) : (TypeInformation)this.getTypeArguments().stream().skip(1L).findFirst().orElse(null);
    }

    @Override
    public Class<S> getType() {
        return this.resolvableType.toClass();
    }

    @Override
    public TypeDescriptor toTypeDescriptor() {
        return new TypeDescriptor(this.resolvableType, this.getType(), null);
    }

    @Override
    public TypeInformation<?> getRawTypeInformation() {
        return new ClassTypeInformation(ResolvableType.forRawClass(this.resolvableType.toClass()));
    }

    @Override
    @Nullable
    public TypeInformation<?> getActualType() {
        if (this.isMap()) {
            return this.getMapValueType();
        }
        if (this.isCollectionLike()) {
            return this.getComponentType();
        }
        if (this.isNullableWrapper()) {
            return this.getComponentType();
        }
        return this;
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return TypeInformation.of(ResolvableType.forMethodReturnType(method, this.getType()));
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Method method) {
        Assert.notNull((Object)method, "Method most not be null");
        return Arrays.stream(method.getParameters()).map(MethodParameter::forParameter).map(it -> ResolvableType.forMethodParameter(it, this.resolvableType)).map(TypeInformation::of).toList();
    }

    @Override
    @Nullable
    public TypeInformation<?> getSuperTypeInformation(Class<?> superType) {
        Class<S> rawType = this.getType();
        if (!superType.isAssignableFrom(rawType)) {
            return null;
        }
        if (rawType.equals(superType)) {
            return this;
        }
        ResolvableType resolvableSuperType = this.resolvableType.as(superType);
        Type type = this.resolvableType.getType();
        if (!(type instanceof Class) || !ObjectUtils.isEmpty(((Class)type).getTypeParameters())) {
            return TypeInformation.of(resolvableSuperType);
        }
        boolean noGenericsResolvable = !Arrays.stream(resolvableSuperType.resolveGenerics()).filter(it -> it != null).findAny().isPresent();
        return noGenericsResolvable ? new ClassTypeInformation(ResolvableType.forRawClass(superType)) : TypeInformation.of(resolvableSuperType);
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        TypeInformation<S> superTypeInformation = target.getSuperTypeInformation(this.getType());
        if (superTypeInformation == null) {
            return false;
        }
        if (superTypeInformation.equals(this)) {
            return true;
        }
        return this.resolvableType.isAssignableFrom(target.getType());
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        return this.typeArguments.get();
    }

    private List<TypeInformation<?>> doGetTypeArguments() {
        if (!this.resolvableType.hasGenerics()) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.resolvableType.getGenerics()).map(it -> it.resolve(Object.class) == null ? null : TypeInformation.of(it)).toList();
    }

    @Override
    public TypeInformation<? extends S> specialize(TypeInformation<?> type) {
        if (this.getTypeArguments().size() == type.getTypeArguments().size()) {
            return TypeInformation.of(ResolvableType.forClassWithGenerics(type.getType(), this.resolvableType.getGenerics()));
        }
        return TypeInformation.of(type.getType());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !ObjectUtils.nullSafeEquals(this.getClass(), o.getClass())) {
            return false;
        }
        TypeDiscoverer that = (TypeDiscoverer)o;
        if (!ObjectUtils.nullSafeEquals(this.getType(), that.getType())) {
            return false;
        }
        List collect1 = Arrays.stream(this.resolvableType.getGenerics()).map(ResolvableType::toClass).collect(Collectors.toList());
        List collect2 = Arrays.stream(that.resolvableType.getGenerics()).map(ResolvableType::toClass).collect(Collectors.toList());
        return ObjectUtils.nullSafeEquals(collect1, collect2);
    }

    public int hashCode() {
        int result = 31 * this.getClass().hashCode();
        return result += 31 * this.getType().hashCode();
    }

    public String toString() {
        return this.resolvableType.toString();
    }

    @Nullable
    private TypeInformation<?> getTypeArgument(Class<?> bound, int index) {
        TypeInformation<?> superTypeInformation = this.getSuperTypeInformation(bound);
        if (superTypeInformation == null) {
            return null;
        }
        List<TypeInformation<?>> arguments = superTypeInformation.getTypeArguments();
        if (arguments.isEmpty() || index > arguments.size() - 1) {
            return null;
        }
        return arguments.get(index);
    }

    private Optional<TypeInformation<?>> getPropertyInformation(String fieldname) {
        Class<S> rawType = this.getType();
        Field field = ReflectionUtils.findField(rawType, fieldname);
        return field != null ? Optional.of(TypeInformation.of(ResolvableType.forField(field, this.resolvableType))) : Optional.ofNullable(BeanUtils.getPropertyDescriptor(rawType, fieldname)).map(it -> this.from((PropertyDescriptor)it, rawType)).map(TypeInformation::of);
    }

    private ResolvableType from(PropertyDescriptor descriptor, Class<?> rawType) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            return ResolvableType.forMethodReturnType(method, rawType);
        }
        method = descriptor.getWriteMethod();
        if (method != null) {
            return ResolvableType.forMethodParameter(method, 0, rawType);
        }
        return ResolvableType.forType(descriptor.getPropertyType(), this.resolvableType);
    }

    private boolean isNullableWrapper() {
        return NullableWrapperConverters.supports(this.getType());
    }
}

