/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.util.ObjectUtils;

public class TypeUtils {
    public static String TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.TransactionManager";

    public static Set<MergedAnnotation<Annotation>> resolveUsedAnnotations(Class<?> type) {
        LinkedHashSet<MergedAnnotation<Annotation>> annotations = new LinkedHashSet<MergedAnnotation<Annotation>>();
        annotations.addAll(TypeUtils.resolveAnnotationsFor(type).toList());
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            annotations.addAll(TypeUtils.resolveAnnotationsFor(constructor).toList());
            for (Parameter parameter : constructor.getParameters()) {
                annotations.addAll(TypeUtils.resolveAnnotationsFor(parameter).toList());
            }
        }
        for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
            annotations.addAll(TypeUtils.resolveAnnotationsFor(accessibleObject).toList());
        }
        try {
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                annotations.addAll(TypeUtils.resolveAnnotationsFor(accessibleObject).toList());
                for (Parameter parameter : ((Executable)accessibleObject).getParameters()) {
                    annotations.addAll(TypeUtils.resolveAnnotationsFor(parameter).toList());
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return annotations;
    }

    public static Stream<MergedAnnotation<Annotation>> resolveAnnotationsFor(AnnotatedElement element) {
        return TypeUtils.resolveAnnotationsFor(element, AnnotationFilter.PLAIN);
    }

    public static Stream<MergedAnnotation<Annotation>> resolveAnnotationsFor(AnnotatedElement element, AnnotationFilter filter2) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.standardRepeatables(), filter2).stream();
    }

    public static Collection<Class<Annotation>> resolveAnnotationTypesFor(AnnotatedElement element, AnnotationFilter filter2) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.standardRepeatables(), filter2).stream().map(MergedAnnotation::getType).toList();
    }

    public static Collection<Class<Annotation>> resolveAnnotationTypesFor(AnnotatedElement element) {
        return TypeUtils.resolveAnnotationTypesFor(element, AnnotationFilter.PLAIN);
    }

    public static boolean isAnnotationFromOrMetaAnnotated(Class<? extends Annotation> annotation, String prefix) {
        if (annotation.getPackage().getName().startsWith(prefix)) {
            return true;
        }
        return TypeUtils.resolveAnnotationsFor(annotation).anyMatch(it -> it.getType().getPackage().getName().startsWith(prefix));
    }

    public static boolean hasAnnotatedField(Class<?> type, String annotationName) {
        for (Field field : type.getDeclaredFields()) {
            MergedAnnotations fieldAnnotations = MergedAnnotations.from(field);
            boolean hasAnnotation = fieldAnnotations.get(annotationName).isPresent();
            if (!hasAnnotation) continue;
            return true;
        }
        return false;
    }

    public static Set<Field> getAnnotatedField(Class<?> type, String annotationName) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (!MergedAnnotations.from(field).get(annotationName).isPresent()) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Set<Class<?>> resolveTypesInSignature(Class<?> owner, Method method) {
        LinkedHashSet signature = new LinkedHashSet();
        signature.addAll(TypeUtils.resolveTypesInSignature(ResolvableType.forMethodReturnType(method, owner)));
        for (Parameter parameter : method.getParameters()) {
            signature.addAll(TypeUtils.resolveTypesInSignature(ResolvableType.forMethodParameter(MethodParameter.forParameter(parameter))));
        }
        return signature;
    }

    public static Set<Class<?>> resolveTypesInSignature(Class<?> owner, Constructor<?> constructor) {
        LinkedHashSet signature = new LinkedHashSet();
        for (int i2 = 0; i2 < constructor.getParameterCount(); ++i2) {
            signature.addAll(TypeUtils.resolveTypesInSignature(ResolvableType.forConstructorParameter(constructor, i2, owner)));
        }
        return signature;
    }

    public static Set<Class<?>> resolveTypesInSignature(Class<?> root) {
        LinkedHashSet signature = new LinkedHashSet();
        TypeUtils.resolveTypesInSignature(ResolvableType.forClass(root), signature);
        return signature;
    }

    public static Set<Class<?>> resolveTypesInSignature(ResolvableType root) {
        LinkedHashSet signature = new LinkedHashSet();
        TypeUtils.resolveTypesInSignature(root, signature);
        return signature;
    }

    private static void resolveTypesInSignature(ResolvableType current, Set<Class<?>> signatures) {
        if (ResolvableType.NONE.equals(current) || ObjectUtils.nullSafeEquals(Void.TYPE, current.getType()) || ObjectUtils.nullSafeEquals(Object.class, current.getType())) {
            return;
        }
        if (signatures.contains(current.toClass())) {
            return;
        }
        signatures.add(current.toClass());
        TypeUtils.resolveTypesInSignature(current.getSuperType(), signatures);
        for (ResolvableType type : current.getGenerics()) {
            TypeUtils.resolveTypesInSignature(type, signatures);
        }
        for (ResolvableType type : current.getInterfaces()) {
            TypeUtils.resolveTypesInSignature(type, signatures);
        }
    }

    public static TypeOps type(Class<?> type) {
        return new TypeOpsImpl(type);
    }

    private static class TypeOpsImpl
    implements TypeOps {
        private final Class<?> type;

        TypeOpsImpl(Class<?> type) {
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    private static class PackageFilter
    implements TypeOps.PackageFilter {
        Set<String> packageNames;

        PackageFilter(Set<String> packageNames) {
            this.packageNames = packageNames;
        }

        static PackageFilter of(String ... packageNames) {
            LinkedHashSet<String> target = new LinkedHashSet<String>();
            for (String pkgName : packageNames) {
                target.add((String)(pkgName.endsWith(".") ? pkgName : pkgName + "."));
            }
            return new PackageFilter(target);
        }

        @Override
        public boolean matches(String typeName) {
            for (String pgkName : this.packageNames) {
                if (!typeName.startsWith(pgkName)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface TypeOps {
        public Class<?> getType();

        default public boolean isPartOf(String ... packageNames) {
            return this.isPartOf(org.springframework.data.util.TypeUtils$PackageFilter.of(packageNames));
        }

        default public boolean isPartOf(PackageFilter ... packageFilters) {
            for (PackageFilter filter2 : packageFilters) {
                if (!filter2.matches(this.getType().getName())) continue;
                return true;
            }
            return false;
        }

        default public Set<Class<?>> signatureTypes() {
            return TypeUtils.resolveTypesInSignature(this.getType());
        }

        public static interface PackageFilter {
            default public boolean matches(Class<?> type) {
                return this.matches(type.getName());
            }

            public boolean matches(String var1);

            public static PackageFilter of(String ... packages) {
                return org.springframework.data.util.TypeUtils$PackageFilter.of(packages);
            }
        }
    }
}

