/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();

    public MockMultipartHttpServletRequest() {
        this(null);
    }

    public MockMultipartHttpServletRequest(@Nullable ServletContext servletContext) {
        super(servletContext);
        this.setMethod("POST");
        this.setContentType("multipart/form-data");
    }

    public void addFile(MultipartFile file) {
        Assert.notNull((Object)file, "MultipartFile must not be null");
        this.multipartFiles.add(file.getName(), file);
    }

    @Override
    public Iterator<String> getFileNames() {
        return this.multipartFiles.keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return this.multipartFiles.getFirst(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get(name);
        return Objects.requireNonNullElse(multipartFiles, Collections.emptyList());
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return this.multipartFiles.toSingleValueMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap<String, MultipartFile>(this.multipartFiles);
    }

    @Override
    public String getMultipartContentType(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            return file.getContentType();
        }
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                return part.getContentType();
            }
        }
        catch (ServletException | IOException ex) {
            throw new IllegalStateException(ex);
        }
        return null;
    }

    @Override
    public HttpMethod getRequestMethod() {
        String method = this.getMethod();
        Assert.state(method != null, "Method must not be null");
        return HttpMethod.valueOf(method);
    }

    @Override
    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            headers.put(headerName, (List<String>)Collections.list(this.getHeaders(headerName)));
        }
        return headers;
    }

    @Override
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            HttpHeaders headers = new HttpHeaders();
            if (file.getContentType() != null) {
                headers.add("Content-Type", file.getContentType());
            }
            return headers;
        }
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                HttpHeaders headers = new HttpHeaders();
                for (String headerName : part.getHeaderNames()) {
                    headers.put(headerName, (List<String>)new ArrayList<String>(part.getHeaders(headerName)));
                }
                return headers;
            }
        }
        catch (Throwable ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
        return null;
    }
}

