/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MockPart
implements Part {
    private final String name;
    @Nullable
    private final String filename;
    private final byte[] content;
    private final HttpHeaders headers = new HttpHeaders();

    public MockPart(String name, @Nullable byte[] content) {
        this(name, null, content);
    }

    public MockPart(String name, @Nullable String filename, @Nullable byte[] content) {
        Assert.hasLength(name, "'name' must not be empty");
        this.name = name;
        this.filename = filename;
        this.content = content != null ? content : new byte[]{};
        this.headers.setContentDispositionFormData(name, filename);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getSubmittedFileName() {
        return this.filename;
    }

    @Override
    @Nullable
    public String getContentType() {
        MediaType contentType = this.headers.getContentType();
        return contentType != null ? contentType.toString() : null;
    }

    @Override
    public long getSize() {
        return this.content.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public void write(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues != null ? headerValues : Collections.emptyList();
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

