/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationObservationContext;

public final class AuthenticationObservationConvention
implements ObservationConvention<AuthenticationObservationContext> {
    static final String OBSERVATION_NAME = "spring.security.authentications";

    @Override
    public String getName() {
        return OBSERVATION_NAME;
    }

    @Override
    public String getContextualName(AuthenticationObservationContext context) {
        if (context.getAuthenticationRequest() != null) {
            String authenticationType = context.getAuthenticationRequest().getClass().getSimpleName();
            if (authenticationType.endsWith("Token")) {
                authenticationType = authenticationType.substring(0, authenticationType.lastIndexOf("Token"));
            }
            if (authenticationType.endsWith("Authentication")) {
                authenticationType = authenticationType.substring(0, authenticationType.lastIndexOf("Authentication"));
            }
            return "authenticate " + authenticationType.toLowerCase();
        }
        return "authenticate";
    }

    @Override
    @NotNull
    public KeyValues getLowCardinalityKeyValues(@NonNull AuthenticationObservationContext context) {
        return KeyValues.of("authentication.request.type", this.getAuthenticationType(context)).and("authentication.method", this.getAuthenticationMethod(context)).and("authentication.result.type", this.getAuthenticationResult(context)).and("authentication.failure.type", this.getAuthenticationFailureType(context));
    }

    private String getAuthenticationType(AuthenticationObservationContext context) {
        if (context.getAuthenticationRequest() == null) {
            return "unknown";
        }
        return context.getAuthenticationRequest().getClass().getSimpleName();
    }

    private String getAuthenticationMethod(AuthenticationObservationContext context) {
        if (context.getAuthenticationManagerClass() == null) {
            return "unknown";
        }
        return context.getAuthenticationManagerClass().getSimpleName();
    }

    private String getAuthenticationResult(AuthenticationObservationContext context) {
        if (context.getAuthenticationResult() == null) {
            return "n/a";
        }
        return context.getAuthenticationResult().getClass().getSimpleName();
    }

    private String getAuthenticationFailureType(AuthenticationObservationContext context) {
        if (context.getError() == null) {
            return "n/a";
        }
        return context.getError().getClass().getSimpleName();
    }

    @Override
    public boolean supportsContext(@NotNull Observation.Context context) {
        return context instanceof AuthenticationObservationContext;
    }
}

