/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoginUrlAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog(LoginUrlAuthenticationEntryPoint.class);
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private String loginFormUrl;
    private boolean forceHttps = false;
    private boolean useForward = false;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public LoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        Assert.notNull((Object)loginFormUrl, "loginFormUrl cannot be null");
        this.loginFormUrl = loginFormUrl;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.isTrue(StringUtils.hasText(this.loginFormUrl) && UrlUtils.isValidRedirectUrl(this.loginFormUrl), "loginFormUrl must be specified and must be a valid redirect URL");
        Assert.isTrue(!this.useForward || !UrlUtils.isAbsoluteUrl(this.loginFormUrl), "useForward must be false if using an absolute loginFormURL");
        Assert.notNull((Object)this.portMapper, "portMapper must be specified");
        Assert.notNull((Object)this.portResolver, "portResolver must be specified");
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request2, HttpServletResponse response, AuthenticationException exception) {
        return this.getLoginFormUrl();
    }

    @Override
    public void commence(HttpServletRequest request2, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (!this.useForward) {
            String redirectUrl = this.buildRedirectUrlToLoginPage(request2, response, authException);
            this.redirectStrategy.sendRedirect(request2, response, redirectUrl);
            return;
        }
        String redirectUrl = null;
        if (this.forceHttps && "http".equals(request2.getScheme())) {
            redirectUrl = this.buildHttpsRedirectUrlForRequest(request2);
        }
        if (redirectUrl != null) {
            this.redirectStrategy.sendRedirect(request2, response, redirectUrl);
            return;
        }
        String loginForm = this.determineUrlToUseForThisRequest(request2, response, authException);
        logger.debug(LogMessage.format("Server side forward to: %s", (Object)loginForm));
        RequestDispatcher dispatcher = request2.getRequestDispatcher(loginForm);
        dispatcher.forward(request2, response);
    }

    protected String buildRedirectUrlToLoginPage(HttpServletRequest request2, HttpServletResponse response, AuthenticationException authException) {
        String loginForm = this.determineUrlToUseForThisRequest(request2, response, authException);
        if (UrlUtils.isAbsoluteUrl(loginForm)) {
            return loginForm;
        }
        int serverPort = this.portResolver.getServerPort(request2);
        String scheme = request2.getScheme();
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(scheme);
        urlBuilder.setServerName(request2.getServerName());
        urlBuilder.setPort(serverPort);
        urlBuilder.setContextPath(request2.getContextPath());
        urlBuilder.setPathInfo(loginForm);
        if (this.forceHttps && "http".equals(scheme)) {
            Integer httpsPort = this.portMapper.lookupHttpsPort(serverPort);
            if (httpsPort != null) {
                urlBuilder.setScheme("https");
                urlBuilder.setPort(httpsPort);
            } else {
                logger.warn(LogMessage.format("Unable to redirect to HTTPS as no port mapping found for HTTP port %s", (Object)serverPort));
            }
        }
        return urlBuilder.getUrl();
    }

    protected String buildHttpsRedirectUrlForRequest(HttpServletRequest request2) throws IOException, ServletException {
        int serverPort = this.portResolver.getServerPort(request2);
        Integer httpsPort = this.portMapper.lookupHttpsPort(serverPort);
        if (httpsPort != null) {
            RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setServerName(request2.getServerName());
            urlBuilder.setPort(httpsPort);
            urlBuilder.setContextPath(request2.getContextPath());
            urlBuilder.setServletPath(request2.getServletPath());
            urlBuilder.setPathInfo(request2.getPathInfo());
            urlBuilder.setQuery(request2.getQueryString());
            return urlBuilder.getUrl();
        }
        logger.warn(LogMessage.format("Unable to redirect to HTTPS as no port mapping found for HTTP port %s", (Object)serverPort));
        return null;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    protected boolean isForceHttps() {
        return this.forceHttps;
    }

    public String getLoginFormUrl() {
        return this.loginFormUrl;
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, "portMapper cannot be null");
        this.portMapper = portMapper;
    }

    protected PortMapper getPortMapper() {
        return this.portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        Assert.notNull((Object)portResolver, "portResolver cannot be null");
        this.portResolver = portResolver;
    }

    protected PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setUseForward(boolean useForward) {
        this.useForward = useForward;
    }

    protected boolean isUseForward() {
        return this.useForward;
    }
}

