/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.context.SupplierDeferredSecurityContext;
import org.springframework.util.Assert;

public final class RequestAttributeSecurityContextRepository
implements SecurityContextRepository {
    public static final String DEFAULT_REQUEST_ATTR_NAME = RequestAttributeSecurityContextRepository.class.getName().concat(".SPRING_SECURITY_CONTEXT");
    private final String requestAttributeName;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    public RequestAttributeSecurityContextRepository() {
        this(DEFAULT_REQUEST_ATTR_NAME);
    }

    public RequestAttributeSecurityContextRepository(String requestAttributeName) {
        this.requestAttributeName = requestAttributeName;
    }

    @Override
    public boolean containsContext(HttpServletRequest request2) {
        return this.getContext(request2) != null;
    }

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        return (SecurityContext)this.loadDeferredContext(requestResponseHolder.getRequest()).get();
    }

    @Override
    public DeferredSecurityContext loadDeferredContext(HttpServletRequest request2) {
        Supplier<SecurityContext> supplier = () -> this.getContext(request2);
        return new SupplierDeferredSecurityContext(supplier, this.securityContextHolderStrategy);
    }

    private SecurityContext getContext(HttpServletRequest request2) {
        return (SecurityContext)request2.getAttribute(this.requestAttributeName);
    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request2, HttpServletResponse response) {
        request2.setAttribute(this.requestAttributeName, context);
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

