/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.util.Assert;

@Deprecated
public final class LazyCsrfTokenRepository
implements CsrfTokenRepository {
    private static final String HTTP_RESPONSE_ATTR = HttpServletResponse.class.getName();
    private final CsrfTokenRepository delegate;
    private boolean deferLoadToken;

    public LazyCsrfTokenRepository(CsrfTokenRepository delegate) {
        Assert.notNull((Object)delegate, "delegate cannot be null");
        this.delegate = delegate;
    }

    public void setDeferLoadToken(boolean deferLoadToken) {
        this.deferLoadToken = deferLoadToken;
    }

    @Override
    public CsrfToken generateToken(HttpServletRequest request2) {
        return this.wrap(request2, this.delegate.generateToken(request2));
    }

    @Override
    public void saveToken(CsrfToken token, HttpServletRequest request2, HttpServletResponse response) {
        if (token == null) {
            this.delegate.saveToken(token, request2, response);
        }
    }

    @Override
    public CsrfToken loadToken(HttpServletRequest request2) {
        if (this.deferLoadToken) {
            return new LazyLoadCsrfToken(request2, this.delegate);
        }
        return this.delegate.loadToken(request2);
    }

    private CsrfToken wrap(HttpServletRequest request2, CsrfToken token) {
        HttpServletResponse response = this.getResponse(request2);
        return new SaveOnAccessCsrfToken(this.delegate, request2, response, token);
    }

    private HttpServletResponse getResponse(HttpServletRequest request2) {
        HttpServletResponse response = (HttpServletResponse)request2.getAttribute(HTTP_RESPONSE_ATTR);
        Assert.notNull((Object)response, () -> "The HttpServletRequest attribute must contain an HttpServletResponse for the attribute " + HTTP_RESPONSE_ATTR);
        return response;
    }

    private final class LazyLoadCsrfToken
    implements CsrfToken {
        private final HttpServletRequest request;
        private final CsrfTokenRepository tokenRepository;
        private CsrfToken token;

        private LazyLoadCsrfToken(HttpServletRequest request2, CsrfTokenRepository tokenRepository) {
            this.request = request2;
            this.tokenRepository = tokenRepository;
        }

        private CsrfToken getDelegate() {
            if (this.token != null) {
                return this.token;
            }
            this.token = LazyCsrfTokenRepository.this.delegate.loadToken(this.request);
            if (this.token == null) {
                this.token = LazyCsrfTokenRepository.this.generateToken(this.request);
            }
            return this.token;
        }

        @Override
        public String getHeaderName() {
            return this.getDelegate().getHeaderName();
        }

        @Override
        public String getParameterName() {
            return this.getDelegate().getParameterName();
        }

        @Override
        public String getToken() {
            return this.getDelegate().getToken();
        }

        public String toString() {
            return "LazyLoadCsrfToken{token=" + this.token + "}";
        }
    }

    private static final class SaveOnAccessCsrfToken
    implements CsrfToken {
        private transient CsrfTokenRepository tokenRepository;
        private transient HttpServletRequest request;
        private transient HttpServletResponse response;
        private final CsrfToken delegate;

        SaveOnAccessCsrfToken(CsrfTokenRepository tokenRepository, HttpServletRequest request2, HttpServletResponse response, CsrfToken delegate) {
            this.tokenRepository = tokenRepository;
            this.request = request2;
            this.response = response;
            this.delegate = delegate;
        }

        @Override
        public String getHeaderName() {
            return this.delegate.getHeaderName();
        }

        @Override
        public String getParameterName() {
            return this.delegate.getParameterName();
        }

        @Override
        public String getToken() {
            this.saveTokenIfNecessary();
            return this.delegate.getToken();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SaveOnAccessCsrfToken other = (SaveOnAccessCsrfToken)obj;
            return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
            return result;
        }

        public String toString() {
            return "SaveOnAccessCsrfToken [delegate=" + this.delegate + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveTokenIfNecessary() {
            if (this.tokenRepository == null) {
                return;
            }
            SaveOnAccessCsrfToken saveOnAccessCsrfToken = this;
            synchronized (saveOnAccessCsrfToken) {
                if (this.tokenRepository != null) {
                    this.tokenRepository.saveToken(this.delegate, this.request, this.response);
                    this.tokenRepository = null;
                    this.request = null;
                    this.response = null;
                }
            }
        }
    }
}

