/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header;

import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.OnCommittedResponseWrapper;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class HeaderWriterFilter
extends OncePerRequestFilter {
    private final List<HeaderWriter> headerWriters;
    private boolean shouldWriteHeadersEagerly = false;

    public HeaderWriterFilter(List<HeaderWriter> headerWriters) {
        Assert.notEmpty(headerWriters, "headerWriters cannot be null or empty");
        this.headerWriters = headerWriters;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.shouldWriteHeadersEagerly) {
            this.doHeadersBefore(request2, response, filterChain);
        } else {
            this.doHeadersAfter(request2, response, filterChain);
        }
    }

    private void doHeadersBefore(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.writeHeaders(request2, response);
        filterChain.doFilter(request2, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHeadersAfter(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HeaderWriterResponse headerWriterResponse = new HeaderWriterResponse(request2, response);
        HeaderWriterRequest headerWriterRequest = new HeaderWriterRequest(request2, headerWriterResponse);
        try {
            filterChain.doFilter(headerWriterRequest, headerWriterResponse);
        }
        finally {
            headerWriterResponse.writeHeaders();
        }
    }

    void writeHeaders(HttpServletRequest request2, HttpServletResponse response) {
        for (HeaderWriter writer : this.headerWriters) {
            writer.writeHeaders(request2, response);
        }
    }

    public void setShouldWriteHeadersEagerly(boolean shouldWriteHeadersEagerly) {
        this.shouldWriteHeadersEagerly = shouldWriteHeadersEagerly;
    }

    class HeaderWriterResponse
    extends OnCommittedResponseWrapper {
        private final HttpServletRequest request;

        HeaderWriterResponse(HttpServletRequest request2, HttpServletResponse response) {
            super(response);
            this.request = request2;
        }

        @Override
        protected void onResponseCommitted() {
            this.writeHeaders();
            this.disableOnResponseCommitted();
        }

        protected void writeHeaders() {
            if (this.isDisableOnResponseCommitted()) {
                return;
            }
            HeaderWriterFilter.this.writeHeaders(this.request, this.getHttpResponse());
        }

        private HttpServletResponse getHttpResponse() {
            return (HttpServletResponse)this.getResponse();
        }
    }

    static class HeaderWriterRequest
    extends HttpServletRequestWrapper {
        private final HeaderWriterResponse response;

        HeaderWriterRequest(HttpServletRequest request2, HeaderWriterResponse response) {
            super(request2);
            this.response = response;
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String path) {
            return new HeaderWriterRequestDispatcher(super.getRequestDispatcher(path), this.response);
        }
    }

    static class HeaderWriterRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher delegate;
        private final HeaderWriterResponse response;

        HeaderWriterRequestDispatcher(RequestDispatcher delegate, HeaderWriterResponse response) {
            this.delegate = delegate;
            this.response = response;
        }

        @Override
        public void forward(ServletRequest request2, ServletResponse response) throws ServletException, IOException {
            this.delegate.forward(request2, response);
        }

        @Override
        public void include(ServletRequest request2, ServletResponse response) throws ServletException, IOException {
            this.response.onResponseCommitted();
            this.delegate.include(request2, response);
        }
    }
}

