/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class DelegatingRequestMatcherHeaderWriter
implements HeaderWriter {
    private final RequestMatcher requestMatcher;
    private final HeaderWriter delegateHeaderWriter;

    public DelegatingRequestMatcherHeaderWriter(RequestMatcher requestMatcher, HeaderWriter delegateHeaderWriter) {
        Assert.notNull((Object)requestMatcher, "requestMatcher cannot be null");
        Assert.notNull((Object)delegateHeaderWriter, "delegateHeaderWriter cannot be null");
        this.requestMatcher = requestMatcher;
        this.delegateHeaderWriter = delegateHeaderWriter;
    }

    @Override
    public void writeHeaders(HttpServletRequest request2, HttpServletResponse response) {
        if (this.requestMatcher.matches(request2)) {
            this.delegateHeaderWriter.writeHeaders(request2, response);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [requestMatcher=" + this.requestMatcher + ", delegateHeaderWriter=" + this.delegateHeaderWriter + "]";
    }
}

