/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.util.Assert;

public final class FeaturePolicyHeaderWriter
implements HeaderWriter {
    private static final String FEATURE_POLICY_HEADER = "Feature-Policy";
    private String policyDirectives;

    public FeaturePolicyHeaderWriter(String policyDirectives) {
        this.setPolicyDirectives(policyDirectives);
    }

    @Override
    public void writeHeaders(HttpServletRequest request2, HttpServletResponse response) {
        if (!response.containsHeader(FEATURE_POLICY_HEADER)) {
            response.setHeader(FEATURE_POLICY_HEADER, this.policyDirectives);
        }
    }

    public void setPolicyDirectives(String policyDirectives) {
        Assert.hasLength(policyDirectives, "policyDirectives must not be null or empty");
        this.policyDirectives = policyDirectives;
    }

    public String toString() {
        return this.getClass().getName() + " [policyDirectives=" + this.policyDirectives + "]";
    }
}

