/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.savedrequest.SavedRequestAwareWrapper;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class HttpSessionRequestCache
implements RequestCache {
    static final String SAVED_REQUEST = "SPRING_SECURITY_SAVED_REQUEST";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private String sessionAttrName = "SPRING_SECURITY_SAVED_REQUEST";
    private String matchingRequestParameterName = "continue";

    @Override
    public void saveRequest(HttpServletRequest request2, HttpServletResponse response) {
        if (!this.requestMatcher.matches(request2)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Did not save request since it did not match [%s]", (Object)this.requestMatcher));
            }
            return;
        }
        if (this.createSessionAllowed || request2.getSession(false) != null) {
            DefaultSavedRequest savedRequest = new DefaultSavedRequest(request2, this.portResolver, this.matchingRequestParameterName);
            request2.getSession().setAttribute(this.sessionAttrName, savedRequest);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(LogMessage.format("Saved request %s to session", (Object)savedRequest.getRedirectUrl()));
            }
        } else {
            this.logger.trace("Did not save request since there's no session and createSessionAllowed is false");
        }
    }

    @Override
    public SavedRequest getRequest(HttpServletRequest currentRequest, HttpServletResponse response) {
        HttpSession session = currentRequest.getSession(false);
        return session != null ? (SavedRequest)session.getAttribute(this.sessionAttrName) : null;
    }

    @Override
    public void removeRequest(HttpServletRequest currentRequest, HttpServletResponse response) {
        HttpSession session = currentRequest.getSession(false);
        if (session != null) {
            this.logger.trace("Removing DefaultSavedRequest from session if present");
            session.removeAttribute(this.sessionAttrName);
        }
    }

    @Override
    public HttpServletRequest getMatchingRequest(HttpServletRequest request2, HttpServletResponse response) {
        if (this.matchingRequestParameterName != null && request2.getParameter(this.matchingRequestParameterName) == null) {
            this.logger.trace("matchingRequestParameterName is required for getMatchingRequest to lookup a value, but not provided");
            return null;
        }
        SavedRequest saved = this.getRequest(request2, response);
        if (saved == null) {
            this.logger.trace("No saved request");
            return null;
        }
        if (!this.matchesSavedRequest(request2, saved)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Did not match request %s to the saved one %s", (Object)UrlUtils.buildRequestUrl(request2), (Object)saved));
            }
            return null;
        }
        this.removeRequest(request2, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(LogMessage.format("Loaded matching saved request %s", (Object)saved.getRedirectUrl()));
        }
        return new SavedRequestAwareWrapper(saved, request2);
    }

    private boolean matchesSavedRequest(HttpServletRequest request2, SavedRequest savedRequest) {
        if (savedRequest instanceof DefaultSavedRequest) {
            DefaultSavedRequest defaultSavedRequest = (DefaultSavedRequest)savedRequest;
            return defaultSavedRequest.doesRequestMatch(request2, this.portResolver);
        }
        String currentUrl = UrlUtils.buildFullRequestUrl(request2);
        return savedRequest.getRedirectUrl().equals(currentUrl);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public void setSessionAttrName(String sessionAttrName) {
        this.sessionAttrName = sessionAttrName;
    }

    public void setMatchingRequestParameterName(String matchingRequestParameterName) {
        this.matchingRequestParameterName = matchingRequestParameterName;
    }
}

