/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.springframework.core.log.LogMessage;
import org.springframework.web.filter.OncePerRequestFilter;

public class ForceEagerSessionCreationFilter
extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpSession session = request2.getSession();
        if (this.logger.isDebugEnabled() && session.isNew()) {
            this.logger.debug(LogMessage.format("Created session eagerly", new Object[0]));
        }
        filterChain.doFilter(request2, response);
    }
}

