/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.util.Assert;

public final class InvalidSessionAccessDeniedHandler
implements AccessDeniedHandler {
    private final InvalidSessionStrategy invalidSessionStrategy;

    public InvalidSessionAccessDeniedHandler(InvalidSessionStrategy invalidSessionStrategy) {
        Assert.notNull((Object)invalidSessionStrategy, "invalidSessionStrategy cannot be null");
        this.invalidSessionStrategy = invalidSessionStrategy;
    }

    @Override
    public void handle(HttpServletRequest request2, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        this.invalidSessionStrategy.onInvalidSessionDetected(request2, response);
    }
}

