/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.util.Assert;

public final class SessionInformationExpiredEvent
extends ApplicationEvent {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public SessionInformationExpiredEvent(SessionInformation sessionInformation, HttpServletRequest request2, HttpServletResponse response) {
        super(sessionInformation);
        Assert.notNull((Object)request2, "request cannot be null");
        Assert.notNull((Object)response, "response cannot be null");
        this.request = request2;
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public SessionInformation getSessionInformation() {
        return (SessionInformation)this.getSource();
    }
}

