/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public abstract class OnCommittedResponseWrapper
extends HttpServletResponseWrapper {
    private boolean disableOnCommitted;
    private long contentLength;
    private long contentWritten;

    public OnCommittedResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void addHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        }
        super.addHeader(name, value);
    }

    @Override
    public void setContentLength(int len) {
        this.setContentLength((long)len);
        super.setContentLength(len);
    }

    @Override
    public void setContentLengthLong(long len) {
        this.setContentLength(len);
        super.setContentLengthLong(len);
    }

    private void setContentLength(long len) {
        this.contentLength = len;
        this.checkContentLength(0L);
    }

    protected void disableOnResponseCommitted() {
        this.disableOnCommitted = true;
    }

    protected boolean isDisableOnResponseCommitted() {
        return this.disableOnCommitted;
    }

    protected abstract void onResponseCommitted();

    @Override
    public final void sendError(int sc) throws IOException {
        this.doOnResponseCommitted();
        super.sendError(sc);
    }

    @Override
    public final void sendError(int sc, String msg) throws IOException {
        this.doOnResponseCommitted();
        super.sendError(sc, msg);
    }

    @Override
    public final void sendRedirect(String location) throws IOException {
        this.doOnResponseCommitted();
        super.sendRedirect(location);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new SaveContextServletOutputStream(super.getOutputStream());
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return new SaveContextPrintWriter(super.getWriter());
    }

    @Override
    public void flushBuffer() throws IOException {
        this.doOnResponseCommitted();
        super.flushBuffer();
    }

    private void trackContentLength(boolean content) {
        if (!this.disableOnCommitted) {
            this.checkContentLength(content ? 4L : 5L);
        }
    }

    private void trackContentLength(char content) {
        if (!this.disableOnCommitted) {
            this.checkContentLength(1L);
        }
    }

    private void trackContentLength(Object content) {
        if (!this.disableOnCommitted) {
            this.trackContentLength(String.valueOf(content));
        }
    }

    private void trackContentLength(byte[] content) {
        if (!this.disableOnCommitted) {
            this.checkContentLength(content != null ? (long)content.length : 0L);
        }
    }

    private void trackContentLength(char[] content) {
        if (!this.disableOnCommitted) {
            this.checkContentLength(content != null ? (long)content.length : 0L);
        }
    }

    private void trackContentLength(int content) {
        if (!this.disableOnCommitted) {
            this.trackContentLength(String.valueOf(content));
        }
    }

    private void trackContentLength(float content) {
        if (!this.disableOnCommitted) {
            this.trackContentLength(String.valueOf(content));
        }
    }

    private void trackContentLength(double content) {
        if (!this.disableOnCommitted) {
            this.trackContentLength(String.valueOf(content));
        }
    }

    private void trackContentLengthLn() {
        if (!this.disableOnCommitted) {
            this.trackContentLength("\r\n");
        }
    }

    private void trackContentLength(String content) {
        if (!this.disableOnCommitted) {
            int contentLength = content != null ? content.length() : 4;
            this.checkContentLength(contentLength);
        }
    }

    private void checkContentLength(long contentLengthToWrite) {
        boolean requiresFlush;
        this.contentWritten += contentLengthToWrite;
        boolean isBodyFullyWritten = this.contentLength > 0L && this.contentWritten >= this.contentLength;
        int bufferSize = this.getBufferSize();
        boolean bl = requiresFlush = bufferSize > 0 && this.contentWritten >= (long)bufferSize;
        if (isBodyFullyWritten || requiresFlush) {
            this.doOnResponseCommitted();
        }
    }

    private void doOnResponseCommitted() {
        if (!this.disableOnCommitted) {
            this.onResponseCommitted();
            this.disableOnResponseCommitted();
        }
    }

    private class SaveContextServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;

        SaveContextServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(b);
            this.delegate.write(b);
        }

        @Override
        public void flush() throws IOException {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.close();
        }

        @Override
        public void print(boolean b) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(b);
            this.delegate.print(b);
        }

        @Override
        public void print(char c) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(c);
            this.delegate.print(c);
        }

        @Override
        public void print(double d) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(d);
            this.delegate.print(d);
        }

        @Override
        public void print(float f) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(f);
            this.delegate.print(f);
        }

        @Override
        public void print(int i2) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(i2);
            this.delegate.print(i2);
        }

        @Override
        public void print(long l) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(l);
            this.delegate.print(l);
        }

        @Override
        public void print(String s) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(s);
            this.delegate.print(s);
        }

        @Override
        public void println() throws IOException {
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println();
        }

        @Override
        public void println(boolean b) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(b);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(b);
        }

        @Override
        public void println(char c) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(c);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(c);
        }

        @Override
        public void println(double d) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(d);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(d);
        }

        @Override
        public void println(float f) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(f);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(f);
        }

        @Override
        public void println(int i2) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(i2);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(i2);
        }

        @Override
        public void println(long l) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(l);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(l);
        }

        @Override
        public void println(String s) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(s);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(s);
        }

        @Override
        public void write(byte[] b) throws IOException {
            OnCommittedResponseWrapper.this.trackContentLength(b);
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OnCommittedResponseWrapper.this.checkContentLength(len);
            this.delegate.write(b, off, len);
        }

        @Override
        public boolean isReady() {
            return this.delegate.isReady();
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }
    }

    private class SaveContextPrintWriter
    extends PrintWriter {
        private final PrintWriter delegate;

        SaveContextPrintWriter(PrintWriter delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.flush();
        }

        @Override
        public void close() {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.close();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        @Override
        public boolean checkError() {
            return this.delegate.checkError();
        }

        @Override
        public void write(int c) {
            OnCommittedResponseWrapper.this.trackContentLength(c);
            this.delegate.write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            OnCommittedResponseWrapper.this.checkContentLength(len);
            this.delegate.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            OnCommittedResponseWrapper.this.trackContentLength(buf);
            this.delegate.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            OnCommittedResponseWrapper.this.checkContentLength(len);
            this.delegate.write(s, off, len);
        }

        @Override
        public void write(String s) {
            OnCommittedResponseWrapper.this.trackContentLength(s);
            this.delegate.write(s);
        }

        @Override
        public void print(boolean b) {
            OnCommittedResponseWrapper.this.trackContentLength(b);
            this.delegate.print(b);
        }

        @Override
        public void print(char c) {
            OnCommittedResponseWrapper.this.trackContentLength(c);
            this.delegate.print(c);
        }

        @Override
        public void print(int i2) {
            OnCommittedResponseWrapper.this.trackContentLength(i2);
            this.delegate.print(i2);
        }

        @Override
        public void print(long l) {
            OnCommittedResponseWrapper.this.trackContentLength(l);
            this.delegate.print(l);
        }

        @Override
        public void print(float f) {
            OnCommittedResponseWrapper.this.trackContentLength(f);
            this.delegate.print(f);
        }

        @Override
        public void print(double d) {
            OnCommittedResponseWrapper.this.trackContentLength(d);
            this.delegate.print(d);
        }

        @Override
        public void print(char[] s) {
            OnCommittedResponseWrapper.this.trackContentLength(s);
            this.delegate.print(s);
        }

        @Override
        public void print(String s) {
            OnCommittedResponseWrapper.this.trackContentLength(s);
            this.delegate.print(s);
        }

        @Override
        public void print(Object obj) {
            OnCommittedResponseWrapper.this.trackContentLength(obj);
            this.delegate.print(obj);
        }

        @Override
        public void println() {
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println();
        }

        @Override
        public void println(boolean x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(char x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(int x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(long x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(float x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(double x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(char[] x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(String x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public void println(Object x) {
            OnCommittedResponseWrapper.this.trackContentLength(x);
            OnCommittedResponseWrapper.this.trackContentLengthLn();
            this.delegate.println(x);
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            return this.delegate.printf(format, args);
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            return this.delegate.printf(l, format, args);
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            return this.delegate.format(format, args);
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            return this.delegate.format(l, format, args);
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            OnCommittedResponseWrapper.this.checkContentLength(csq.length());
            return this.delegate.append(csq);
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            OnCommittedResponseWrapper.this.checkContentLength(end - start);
            return this.delegate.append(csq, start, end);
        }

        @Override
        public PrintWriter append(char c) {
            OnCommittedResponseWrapper.this.trackContentLength(c);
            return this.delegate.append(c);
        }
    }
}

