/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextLoadException;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.aot.AotContextLoader;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.util.Assert;

public abstract class AbstractGenericContextLoader
extends AbstractContextLoader
implements AotContextLoader {
    protected static final Log logger = LogFactory.getLog(AbstractGenericContextLoader.class);

    @Override
    public final ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, false);
    }

    @Override
    public final GenericApplicationContext loadContextForAotProcessing(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, true);
    }

    @Override
    public final GenericApplicationContext loadContextForAotRuntime(MergedContextConfiguration mergedConfig, ApplicationContextInitializer<ConfigurableApplicationContext> initializer) throws Exception {
        Assert.notNull((Object)mergedConfig, "MergedContextConfiguration must not be null");
        Assert.notNull(initializer, "ApplicationContextInitializer must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Loading ApplicationContext for AOT runtime for " + mergedConfig);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Loading ApplicationContext for AOT runtime for test class " + mergedConfig.getTestClass().getName());
        }
        this.validateMergedContextConfiguration(mergedConfig);
        GenericApplicationContext context = this.createContext();
        try {
            this.prepareContext(context);
            this.prepareContext(context, mergedConfig);
            initializer.initialize(context);
            this.customizeContext(context);
            this.customizeContext(context, mergedConfig);
            context.refresh();
            return context;
        }
        catch (Exception ex) {
            throw new ContextLoadException(context, (Throwable)ex);
        }
    }

    private GenericApplicationContext loadContext(MergedContextConfiguration mergedConfig, boolean forAotProcessing) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Loading ApplicationContext %sfor %s".formatted(forAotProcessing ? "for AOT processing " : "", mergedConfig));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Loading ApplicationContext %sfor test class %s".formatted(forAotProcessing ? "for AOT processing " : "", mergedConfig.getTestClass().getName()));
        }
        this.validateMergedContextConfiguration(mergedConfig);
        GenericApplicationContext context = this.createContext();
        try {
            ApplicationContext parent = mergedConfig.getParentApplicationContext();
            if (parent != null) {
                context.setParent(parent);
            }
            this.prepareContext(context);
            this.prepareContext(context, mergedConfig);
            this.customizeBeanFactory(context.getDefaultListableBeanFactory());
            this.loadBeanDefinitions(context, mergedConfig);
            AnnotationConfigUtils.registerAnnotationConfigProcessors(context);
            this.customizeContext(context);
            this.customizeContext(context, mergedConfig);
            if (!forAotProcessing) {
                context.refresh();
                context.registerShutdownHook();
            }
            return context;
        }
        catch (Exception ex) {
            throw new ContextLoadException(context, (Throwable)ex);
        }
    }

    protected void validateMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
    }

    @Override
    @Deprecated(since="6.0")
    public final ConfigurableApplicationContext loadContext(String ... locations) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading ApplicationContext for locations " + Arrays.toString(locations));
        }
        GenericApplicationContext context = this.createContext();
        this.prepareContext(context);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory());
        this.createBeanDefinitionReader(context).loadBeanDefinitions(locations);
        AnnotationConfigUtils.registerAnnotationConfigProcessors(context);
        this.customizeContext(context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected GenericApplicationContext createContext() {
        return new GenericApplicationContext();
    }

    protected void prepareContext(GenericApplicationContext context) {
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        this.createBeanDefinitionReader(context).loadBeanDefinitions(mergedConfig.getLocations());
    }

    protected abstract BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext var1);

    protected void customizeContext(GenericApplicationContext context) {
    }
}

