/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public abstract class JdbcTestUtils {
    private static final Log logger = LogFactory.getLog(JdbcTestUtils.class);

    public static int countRowsInTable(JdbcTemplate jdbcTemplate, String tableName) {
        Integer result = jdbcTemplate.queryForObject("SELECT COUNT(0) FROM " + tableName, Integer.class);
        return result != null ? result : 0;
    }

    public static int countRowsInTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause) {
        Integer result;
        String sql = "SELECT COUNT(0) FROM " + tableName;
        if (StringUtils.hasText(whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        return (result = jdbcTemplate.queryForObject(sql, Integer.class)) != null ? result : 0;
    }

    public static int deleteFromTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        for (String tableName : tableNames) {
            int rowCount = jdbcTemplate.update("DELETE FROM " + tableName);
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info("Deleted " + rowCount + " rows from table " + tableName);
        }
        return totalRowCount;
    }

    public static int deleteFromTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause, Object ... args) {
        int rowCount;
        String sql = "DELETE FROM " + tableName;
        if (StringUtils.hasText(whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        int n = rowCount = args.length > 0 ? jdbcTemplate.update(sql, args) : jdbcTemplate.update(sql);
        if (logger.isInfoEnabled()) {
            logger.info("Deleted " + rowCount + " rows from table " + tableName);
        }
        return rowCount;
    }

    public static void dropTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        for (String tableName : tableNames) {
            jdbcTemplate.execute("DROP TABLE " + tableName);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Dropped table " + tableName);
        }
    }
}

