/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.DelegatingWebConnection;
import org.springframework.test.web.servlet.htmlunit.HostRequestMatcher;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnection;
import org.springframework.test.web.servlet.htmlunit.WebRequestMatcher;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public abstract class MockMvcWebConnectionBuilderSupport<T extends MockMvcWebConnectionBuilderSupport<T>> {
    private final MockMvc mockMvc;
    private final List<WebRequestMatcher> requestMatchers = new ArrayList<WebRequestMatcher>();
    private String contextPath = "";
    private boolean alwaysUseMockMvc;

    protected MockMvcWebConnectionBuilderSupport(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, "MockMvc must not be null");
        this.mockMvc = mockMvc;
        this.requestMatchers.add(new HostRequestMatcher("localhost"));
    }

    protected MockMvcWebConnectionBuilderSupport(WebApplicationContext context) {
        this(MockMvcBuilders.webAppContextSetup(context).build());
    }

    protected MockMvcWebConnectionBuilderSupport(WebApplicationContext context, MockMvcConfigurer configurer) {
        this(((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup(context).apply(configurer)).build());
    }

    public T contextPath(String contextPath) {
        this.contextPath = contextPath;
        return (T)this;
    }

    public T alwaysUseMockMvc() {
        this.alwaysUseMockMvc = true;
        return (T)this;
    }

    public T useMockMvc(WebRequestMatcher ... matchers) {
        Collections.addAll(this.requestMatchers, matchers);
        return (T)this;
    }

    public T useMockMvcForHosts(String ... hosts) {
        this.requestMatchers.add(new HostRequestMatcher(hosts));
        return (T)this;
    }

    protected final WebConnection createConnection(WebClient webClient) {
        Assert.notNull((Object)webClient, "WebClient must not be null");
        return this.createConnection(webClient, webClient.getWebConnection());
    }

    private WebConnection createConnection(WebClient webClient, WebConnection defaultConnection) {
        MockMvcWebConnection connection = new MockMvcWebConnection(this.mockMvc, webClient, this.contextPath);
        if (this.alwaysUseMockMvc) {
            return connection;
        }
        ArrayList<DelegatingWebConnection.DelegateWebConnection> delegates = new ArrayList<DelegatingWebConnection.DelegateWebConnection>(this.requestMatchers.size());
        for (WebRequestMatcher matcher : this.requestMatchers) {
            delegates.add(new DelegatingWebConnection.DelegateWebConnection(matcher, connection));
        }
        return new DelegatingWebConnection(defaultConnection, delegates);
    }
}

