/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.StandardServletPartUtils;
import org.springframework.web.util.WebUtils;

public class ServletRequestDataBinder
extends WebDataBinder {
    public ServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public ServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(ServletRequest request2) {
        HttpServletRequest httpServletRequest;
        ServletRequestParameterPropertyValues mpvs = new ServletRequestParameterPropertyValues(request2);
        MultipartRequest multipartRequest = WebUtils.getNativeRequest(request2, MultipartRequest.class);
        if (multipartRequest != null) {
            this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
        } else if (StringUtils.startsWithIgnoreCase(request2.getContentType(), "multipart/form-data") && (httpServletRequest = WebUtils.getNativeRequest(request2, HttpServletRequest.class)) != null && HttpMethod.POST.matches(httpServletRequest.getMethod())) {
            StandardServletPartUtils.bindParts(httpServletRequest, mpvs, this.isBindEmptyMultipartFiles());
        }
        this.addBindValues(mpvs, request2);
        this.doBind(mpvs);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request2) {
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getBindingResult().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getBindingResult().getObjectName() + "'", new BindException(this.getBindingResult()));
        }
    }
}

