/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ForwardedHeaderTransformer
implements Function<ServerHttpRequest, ServerHttpRequest> {
    static final Set<String> FORWARDED_HEADER_NAMES = Collections.newSetFromMap(new LinkedCaseInsensitiveMap<Boolean>(10, Locale.ENGLISH));
    private boolean removeOnly;

    public void setRemoveOnly(boolean removeOnly) {
        this.removeOnly = removeOnly;
    }

    public boolean isRemoveOnly() {
        return this.removeOnly;
    }

    @Override
    public ServerHttpRequest apply(ServerHttpRequest request2) {
        if (this.hasForwardedHeaders(request2)) {
            ServerHttpRequest.Builder builder = request2.mutate();
            if (!this.removeOnly) {
                URI uri = UriComponentsBuilder.fromHttpRequest(request2).build(true).toUri();
                builder.uri(uri);
                String prefix = ForwardedHeaderTransformer.getForwardedPrefix(request2);
                if (prefix != null) {
                    builder.path(prefix + uri.getRawPath());
                    builder.contextPath(prefix);
                }
                InetSocketAddress remoteAddress = request2.getRemoteAddress();
                if ((remoteAddress = UriComponentsBuilder.parseForwardedFor(request2, remoteAddress)) != null) {
                    builder.remoteAddress(remoteAddress);
                }
            }
            this.removeForwardedHeaders(builder);
            request2 = builder.build();
        }
        return request2;
    }

    protected boolean hasForwardedHeaders(ServerHttpRequest request2) {
        HttpHeaders headers = request2.getHeaders();
        for (String headerName : FORWARDED_HEADER_NAMES) {
            if (!headers.containsKey(headerName)) continue;
            return true;
        }
        return false;
    }

    private void removeForwardedHeaders(ServerHttpRequest.Builder builder) {
        builder.headers(map -> FORWARDED_HEADER_NAMES.forEach(map::remove));
    }

    @Nullable
    private static String getForwardedPrefix(ServerHttpRequest request2) {
        String[] rawPrefixes;
        HttpHeaders headers = request2.getHeaders();
        String header = headers.getFirst("X-Forwarded-Prefix");
        if (header == null) {
            return null;
        }
        StringBuilder prefix = new StringBuilder(header.length());
        for (String rawPrefix : rawPrefixes = StringUtils.tokenizeToStringArray(header, ",")) {
            int endIndex;
            for (endIndex = rawPrefix.length(); endIndex > 1 && rawPrefix.charAt(endIndex - 1) == '/'; --endIndex) {
            }
            prefix.append(endIndex != rawPrefix.length() ? rawPrefix.substring(0, endIndex) : rawPrefix);
        }
        return prefix.toString();
    }

    static {
        FORWARDED_HEADER_NAMES.add("Forwarded");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Prefix");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Ssl");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-For");
    }
}

