/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.AbstractLocaleResolver;

public class AcceptHeaderLocaleResolver
extends AbstractLocaleResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        this.supportedLocales.addAll(locales);
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request2) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && request2.getHeader("Accept-Language") == null) {
            return defaultLocale;
        }
        Locale requestLocale = request2.getLocale();
        List<Locale> supportedLocales = this.getSupportedLocales();
        if (supportedLocales.isEmpty() || supportedLocales.contains(requestLocale)) {
            return requestLocale;
        }
        Locale supportedLocale = this.findSupportedLocale(request2, supportedLocales);
        if (supportedLocale != null) {
            return supportedLocale;
        }
        return defaultLocale != null ? defaultLocale : requestLocale;
    }

    @Nullable
    private Locale findSupportedLocale(HttpServletRequest request2, List<Locale> supportedLocales) {
        Enumeration<Locale> requestLocales = request2.getLocales();
        Locale languageMatch = null;
        block0: while (requestLocales.hasMoreElements()) {
            Locale locale = requestLocales.nextElement();
            if (supportedLocales.contains(locale)) {
                if (languageMatch != null && !languageMatch.getLanguage().equals(locale.getLanguage())) continue;
                return locale;
            }
            if (languageMatch != null) continue;
            for (Locale candidate : supportedLocales) {
                if (StringUtils.hasLength(candidate.getCountry()) || !candidate.getLanguage().equals(locale.getLanguage())) continue;
                languageMatch = candidate;
                continue block0;
            }
        }
        return languageMatch;
    }

    @Override
    public void setLocale(HttpServletRequest request2, @Nullable HttpServletResponse response, @Nullable Locale locale) {
        throw new UnsupportedOperationException("Cannot change HTTP Accept-Language header - use a different locale resolution strategy");
    }
}

