/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.feed;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.WireFeedOutput;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractFeedView<T extends WireFeed>
extends AbstractView {
    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request2, HttpServletResponse response) throws Exception {
        T wireFeed = this.newFeed();
        this.buildFeedMetadata(model, wireFeed, request2);
        this.buildFeedEntries(model, wireFeed, request2, response);
        this.setResponseContentType(request2, response);
        if (!StringUtils.hasText(wireFeed.getEncoding())) {
            wireFeed.setEncoding("UTF-8");
        }
        WireFeedOutput feedOutput = new WireFeedOutput();
        ServletOutputStream out = response.getOutputStream();
        feedOutput.output(wireFeed, (Writer)new OutputStreamWriter((OutputStream)out, wireFeed.getEncoding()));
        out.flush();
    }

    protected abstract T newFeed();

    protected void buildFeedMetadata(Map<String, Object> model, T feed, HttpServletRequest request2) {
    }

    protected abstract void buildFeedEntries(Map<String, Object> var1, T var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;
}

