/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.controller;

import com.roma.romaapi.service.ApiService;
import com.roma.romaapi.service.CaptchaService;
import com.roma.romaapi.utils.CommonUtil;
import com.roma.romaapi.utils.CustomResponse;
import com.roma.romaapi.utils.UUIDUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
public class ApiController {
    private Integer timeout = 600;
    @Autowired
    CaptchaService captchaService;
    @Autowired
    ApiService apiService;
    @Autowired
    private UUIDUtil uuidUtil;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    CommonUtil commonUtil;

    @RequestMapping(value={"/login/verifyCode"})
    public Map<String, Object> loginVerifyCode() throws IOException {
        return this.captchaService.captchaCreator();
    }

    @RequestMapping(value={"/api/login"})
    public Map login(HttpServletRequest request2) {
        Map<String, String[]> maps = request2.getParameterMap();
        Map<String, Object> loginResult = this.apiService.login(maps);
        return CustomResponse.formatResponse(loginResult);
    }

    @RequestMapping(value={"/api/userInfo"})
    public Map userInfo(@RequestHeader(value="Authorization") String authorization) {
        Map<String, Object> loginResult = this.apiService.userInfo(authorization);
        return CustomResponse.formatResponse(loginResult);
    }

    @RequestMapping(value={"/api/logout"})
    public Map logout(@RequestHeader(value="Authorization") String authorization) {
        Map<String, Object> loginResult = this.apiService.logout(authorization);
        return CustomResponse.formatResponse(loginResult);
    }

    @RequestMapping(value={"/api/permissionList"})
    public Map permissionList(HttpServletRequest request2) {
        HashMap<String, List> ret = new HashMap<String, List>();
        List allPermiss = this.apiService.permissionList();
        ret.put("options", allPermiss);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/selectPermissionList"})
    public Map pagePermissionList(HttpServletRequest request2) {
        HashMap<String, List> ret = new HashMap<String, List>();
        List allPermiss = this.apiService.selectPermissionList();
        ret.put("options", allPermiss);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/addPermissions"})
    public Map addPermissions(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.addPermissions(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/permissionDetailed"})
    public Map permissionDetailed(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map detailInfo = this.apiService.permissionDetailById(maps);
        return CustomResponse.formatResponse(detailInfo);
    }

    @RequestMapping(value={"/api/pageList"})
    public Map pageDetailsList() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List pageList = this.apiService.pageList();
        ret.put("options", pageList);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/pageManageList"})
    public Map pageManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.pageListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/pageDetail"})
    public Map pageDetail(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map detailInfo = this.apiService.pageDetailById(maps);
        detailInfo.put("sysPageDetails", "1");
        return CustomResponse.formatResponse(detailInfo);
    }

    @RequestMapping(value={"/api/pageSave"})
    public Map pageSave(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.addPage(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/datasourceManageList"})
    public Map datasourceManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.datasourceListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/saveDatasource"})
    public Map saveDatasource(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.saveDatasource(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/deleteDatasource"})
    public Map deleteDatasource(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.delDatasource(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/sqlManageList"})
    public Map sqlManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.sqlListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/sqlDetailed"})
    public Map sqlDetailed(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.sqlDetailById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/deleteBasic"})
    public Map deleteBasic(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.delDetailById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/deletePermission"})
    public Map deletePermission(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.deletePermissionById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/sqlSave"})
    public Map sqlSave(HttpServletRequest request2, @RequestBody String data, @RequestHeader(value="Authorization") String authorization) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.addSql(maps, authorization);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/sqlList"})
    public Map sqlDetailsList() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List pageList = this.apiService.sqlList();
        ret.put("options", pageList);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/apiList"})
    public Map apiDetailsList() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List apiList = this.apiService.apiList();
        ret.put("options", apiList);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/itemList"})
    public Map itemDetailsList() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List pageList = this.apiService.itemList();
        ret.put("options", pageList);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/roleList"})
    public Map roleList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.roleList(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/roleDetailed"})
    public Map roleDetailed(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.roleDetailById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/roleSave"})
    public Map roleSave(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.addRole(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/apiManageList"})
    public Map apiManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.apiListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/apiSave"})
    public Map apiSave(HttpServletRequest request2, @RequestBody String data, @RequestHeader(value="Authorization") String authorization) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.saveApi(maps, authorization);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/apiDetailed"})
    public Map apiDetailed(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.apiDetailById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/itemManageList"})
    public Map itemManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.itemListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/itemSave"})
    public Map itemSave(HttpServletRequest request2, @RequestBody String data, @RequestHeader(value="Authorization") String authorization) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.saveItem(maps, authorization);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/itemDetailed"})
    public Map itemDetailed(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.itemDetailById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/userManageList"})
    public Map userManageList(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = new HashMap();
        ret = this.apiService.userListHasPaging(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/optionRoleList"})
    public Map optionRoleList() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List pageList = this.apiService.roleList();
        ret.put("options", pageList);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"api/uploadSave"})
    public Map uploadSave(@RequestParam(value="file") MultipartFile file) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Map uploadInfo = this.commonUtil.uploadFile(file);
        if (uploadInfo.containsKey("uploadPath")) {
            ret.put("value", uploadInfo.get("uploadPath").toString());
        }
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/userSave"})
    public Map userSave(HttpServletRequest request2, @RequestBody String data, @RequestHeader(value="Authorization") String authorization) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map ret = this.apiService.userSave(maps, authorization);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/userDetailById"})
    public Map userDetailById(HttpServletRequest request2, @RequestBody String data) {
        Map maps = this.commonUtil.analysisRequestParams(request2, data);
        Map<String, Object> ret = this.apiService.getUserInfoById(maps);
        return CustomResponse.formatResponse(ret);
    }

    @RequestMapping(value={"/api/datasource"})
    public Map optionDatasource() {
        HashMap<String, List> ret = new HashMap<String, List>();
        List pageList = this.apiService.datasource();
        ret.put("options", pageList);
        return CustomResponse.formatResponse(ret);
    }
}

