/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.facade;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MultipleDb {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.url}")
    private String datasourceUrl;
    @Value(value="${spring.datasource.username}")
    private String datasourceUsername;
    @Value(value="${spring.datasource.password}")
    private String datasourcePassword;

    public NamedParameterJdbcTemplate getMultipleDatasourceByDbCode(String dbCode) {
        HashMap<String, String> dbConfigParams = new HashMap<String, String>();
        dbConfigParams.put("dbCode", dbCode);
        Map<Object, Object> dbConfigInfoByDbCode = new HashMap();
        try {
            String dbSourceInfoStringSql = " SELECT * FROM `datasource_config` WHERE `datasource_code`=:dbCode ";
            dbConfigInfoByDbCode = this.namedParameterJdbcTemplate.queryForMap(dbSourceInfoStringSql, dbConfigParams);
        }
        catch (EmptyResultDataAccessException dbSourceInfoStringSql) {
            // empty catch block
        }
        HikariDataSource customDataConfig = new HikariDataSource();
        customDataConfig.setDriverClassName(this.driverClassName);
        if (dbCode == null || dbCode.equals("") || dbConfigInfoByDbCode.isEmpty()) {
            customDataConfig.setJdbcUrl(this.datasourceUrl);
            customDataConfig.setUsername(this.datasourceUsername);
            customDataConfig.setPassword(this.datasourcePassword);
        } else {
            customDataConfig.setJdbcUrl(dbConfigInfoByDbCode.get("datasource_url").toString());
            customDataConfig.setUsername(dbConfigInfoByDbCode.get("datasource_username").toString());
            customDataConfig.setPassword(dbConfigInfoByDbCode.get("datasource_password").toString());
        }
        NamedParameterJdbcTemplate mulNamedParameterJdbcTemplate = new NamedParameterJdbcTemplate(customDataConfig);
        return mulNamedParameterJdbcTemplate;
    }
}

