/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.interceptor;

import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.roma.romaapi.utils.CustomResponse;
import com.roma.romaapi.utils.JWTUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class JWTInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JWTInterceptor.class);
    @Autowired
    private JWTUtil jwtUtil;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Override
    public boolean preHandle(HttpServletRequest request2, HttpServletResponse response, Object handler) throws Exception {
        if (HttpMethod.OPTIONS.toString().equals(request2.getMethod())) {
            return true;
        }
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        String authorization = request2.getHeader("Authorization");
        if (authorization == null || authorization.length() < 8) {
            errorMap.put("sysErrorCode", "50001");
            errorMap.put("sysErrorMessage", "Header \u672a\u88c5\u8f7d token");
            String json = new ObjectMapper().writeValueAsString(CustomResponse.formatResponse(errorMap));
            this.returnJson(response, json);
            return false;
        }
        String token = authorization.substring(7);
        String redisTokenKey = "JWT_SIGN_" + token;
        String userId = (String)this.stringRedisTemplate.opsForValue().get(redisTokenKey);
        if (null == userId || userId.equals("")) {
            errorMap.put("sysErrorCode", "50000");
            errorMap.put("sysErrorMessage", "token\u5931\u6548\u6216\u5df2\u8fc7\u671f");
            String json = new ObjectMapper().writeValueAsString(CustomResponse.formatResponse(errorMap));
            this.returnJson(response, json);
            return false;
        }
        try {
            DecodedJWT verify = this.jwtUtil.verify(token);
            String loginTimeFromToken = verify.getClaim("userLoginTime").asString();
            this.stringRedisTemplate.opsForValue().set((CallSite)((Object)redisTokenKey), userId, 1800L, TimeUnit.SECONDS);
        }
        catch (SignatureVerificationException e) {
            errorMap.put("sysErrorCode", "50002");
            errorMap.put("sysErrorMessage", "\u65e0\u6548Token\u7b7e\u540d");
            String json = new ObjectMapper().writeValueAsString(CustomResponse.formatResponse(errorMap));
            this.returnJson(response, json);
            return false;
        }
        catch (TokenExpiredException e) {
            this.stringRedisTemplate.opsForValue().set((CallSite)((Object)redisTokenKey), userId, 1800L, TimeUnit.SECONDS);
            return true;
        }
        catch (AlgorithmMismatchException e) {
            errorMap.put("sysErrorCode", "50003");
            errorMap.put("sysErrorMessage", "token\u7b97\u6cd5\u4e0d\u4e00\u81f4");
            String json = new ObjectMapper().writeValueAsString(CustomResponse.formatResponse(errorMap));
            this.returnJson(response, json);
            return false;
        }
        catch (Exception e) {
            errorMap.put("sysErrorCode", "50004");
            errorMap.put("sysErrorMessage", "token\u65e0\u6548:" + e.getMessage());
            String json = new ObjectMapper().writeValueAsString(CustomResponse.formatResponse(errorMap));
            this.returnJson(response, json);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(HttpServletResponse response, String result) throws Exception {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        try {
            writer = response.getWriter();
            writer.print(result);
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

