/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.service;

import com.roma.romaapi.dao.DbApiDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbApiService {
    @Autowired
    DbApiDao dbApiDao;

    public Map<String, Object> transferSql(String sqlCode, Map<String, String> maps) {
        Map<String, Object> hasSql = this.dbApiDao.dbQueryForMap(sqlCode);
        boolean isEmpty = hasSql.containsKey("sysErrorCode");
        if (isEmpty) {
            return hasSql;
        }
        String page = "1";
        String perPage = "15";
        HashMap<String, String> bindData = new HashMap<String, String>();
        Object sqlBehavior = hasSql.get("sql_type");
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            String paramsKey = entry.getKey();
            String paramsValue = entry.getValue();
            String fourBeforestring = "";
            if (paramsKey.length() >= 4 && (fourBeforestring = paramsKey.substring(0, 4)).equals("dbp_")) {
                bindData.put(paramsKey, paramsValue);
            }
            if (paramsKey.equals("page")) {
                page = paramsValue;
            }
            if (!paramsKey.equals("perPage")) continue;
            perPage = paramsValue;
        }
        Map<String, Object> ret = new HashMap<String, Object>();
        switch (sqlBehavior.toString()) {
            case "query": {
                ret = this.transferSelect(hasSql, bindData, page, perPage);
                break;
            }
            case "update": {
                Integer updateRow = this.transferUpdate(hasSql, bindData);
                if (updateRow > 0) break;
                ret.put("sysErrorCode", "500");
                break;
            }
        }
        return ret;
    }

    public Map transferSelect(Map sqlData, Map bindData, String page, String perPage) {
        Map<String, List<Map<String, Object>>> res = new HashMap();
        Object sql = sqlData.get("sql_string");
        Object isList = sqlData.get("is_list");
        String datasource = sqlData.get("datasource_code").toString();
        if (isList.equals(2)) {
            String selectSql = sql.toString();
            res = this.dbApiDao.dbCustomQueryForMap(datasource, selectSql, bindData);
        } else if (isList.equals(1)) {
            Integer nowPage = Integer.parseInt(page);
            Integer nowPerPage = Integer.parseInt(perPage);
            String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + String.valueOf(sql) + " ) AS ROMA";
            Integer count = this.dbApiDao.dbCountQueryForObject(datasource, countSql, bindData);
            Integer maxPage = count / nowPerPage + (count % nowPerPage != 0 ? 1 : 0);
            if (nowPage <= 1) {
                nowPage = 1;
            } else if (maxPage > 0 && nowPage >= maxPage) {
                nowPage = maxPage;
            }
            Integer startNum = (nowPage - 1) * nowPerPage;
            String selectSql = String.valueOf(sql) + " LIMIT " + startNum + "," + nowPerPage;
            List<Map<String, Object>> info2 = this.dbApiDao.dbCustomQueryForList(datasource, selectSql, bindData);
            res.put("count", (List<Map<String, Object>>)((Object)count));
            res.put("rows", info2);
        }
        return res;
    }

    public Integer transferUpdate(Map sqlData, Map bindData) {
        Object sql = sqlData.get("sql_string");
        String datasource = sqlData.get("datasource_code").toString();
        Integer ret = this.dbApiDao.dbUpdate(datasource, sql.toString(), bindData);
        return ret;
    }
}

