/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

@Component
public class CommonUtil {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Value(value="${upload.path}")
    private String configUploadPath;

    public String getUserIdByHeaderAuthorization(String headerAuthorization) {
        String token = headerAuthorization.substring(7);
        String redisTokenKey = "JWT_SIGN_" + token;
        String userId = (String)this.stringRedisTemplate.opsForValue().get(redisTokenKey);
        if (null == userId || userId.equals("")) {
            return "";
        }
        return userId;
    }

    public Boolean logoutDeleteRedisToken(String headerAuthorization) {
        String token = headerAuthorization.substring(7);
        String redisTokenKey = "JWT_SIGN_" + token;
        return this.stringRedisTemplate.delete(redisTokenKey);
    }

    public Map analysisRequestParams(HttpServletRequest request2, @RequestBody String data) {
        HashMap<String, String> ret;
        block5: {
            String requestContentType;
            block4: {
                Map<String, String[]> maps = request2.getParameterMap();
                requestContentType = request2.getContentType();
                ret = new HashMap<String, String>();
                if (!requestContentType.equals("application/x-www-form-urlencoded")) break block4;
                for (Map.Entry<String, String[]> entry : maps.entrySet()) {
                    String paramsKey = entry.getKey();
                    String paramsValue = entry.getValue()[0];
                    ret.put(paramsKey, paramsValue);
                }
                break block5;
            }
            if (!requestContentType.equals("application/json")) break block5;
            try {
                ObjectMapper jacksonMapper = new ObjectMapper();
                Map<String, String> jsonParams = jacksonMapper.readValue(data, new TypeReference<Map<String, String>>(this){});
                for (Map.Entry<String, String> entry : jsonParams.entrySet()) {
                    String paramsKey = entry.getKey();
                    String paramsValue = entry.getValue();
                    ret.put(paramsKey, paramsValue);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String trimFirstAndLastChar(String str, String element) {
        boolean beginIndexFlag = true;
        boolean endIndexFlag = true;
        do {
            int beginIndex = str.indexOf(element) == 0 ? 1 : 0;
            int endIndex = str.lastIndexOf(element) + 1 == str.length() ? str.lastIndexOf(element) : str.length();
            str = str.substring(beginIndex, endIndex);
            beginIndexFlag = str.indexOf(element) == 0;
            boolean bl = endIndexFlag = str.lastIndexOf(element) + 1 == str.length();
        } while (beginIndexFlag || endIndexFlag);
        return str;
    }

    public String getNowYYMMDDHHIISS() {
        Date date = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = fmt.format(date);
        return dateString;
    }

    public Map filterApiBindParams(Map<String, String> maps) {
        HashMap<String, String> bindData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            String paramsKey = entry.getKey();
            String paramsValue = entry.getValue();
            String fourBeforestring = "";
            if (paramsKey.length() < 4 || !(fourBeforestring = paramsKey.substring(0, 4)).equals("api_")) continue;
            bindData.put(paramsKey, paramsValue);
        }
        return bindData;
    }

    public String calcPagingString(Integer count, String page, String perPage) {
        Integer nowPage = Integer.parseInt(page);
        Integer nowPerPage = Integer.parseInt(perPage);
        Integer maxPage = count / nowPerPage + (count % nowPerPage != 0 ? 1 : 0);
        if (nowPage <= 1) {
            nowPage = 1;
        } else if (maxPage > 0 && nowPage >= maxPage) {
            nowPage = maxPage;
        }
        Integer startNum = (nowPage - 1) * nowPerPage;
        String limitAfter = startNum + "," + nowPerPage;
        return limitAfter;
    }

    public String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public String getFileName(String fileOriginName) {
        return this.getUUID() + this.getSuffix(fileOriginName);
    }

    public Map uploadFile(MultipartFile file) {
        Object value = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (file.isEmpty()) {
            map.put("sysErrorCode", "59000");
            return map;
        }
        try {
            String localPath = this.configUploadPath;
            String fileName = file.getOriginalFilename();
            String realPath = localPath + "/" + this.getFileName(fileName);
            File dest = new File(realPath);
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdir();
            }
            file.transferTo(dest);
            value = realPath;
            map.put("uploadPath", value);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("sysErrorCode", "59000");
            return map;
        }
        return map;
    }
}

